/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.jboss.axis.utils.bytecode;

import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/**
 * This class retieves function parameter names from bytecode built with
 * debugging symbols.  Used as a last resort when creating WSDL.
 *
 * @author <a href="mailto:tomj@macromedia.com">Tom Jordahl</a>
 */
public class ParamNameExtractor
{

   private static Logger log = Logger.getLogger(ParamNameExtractor.class.getName());

   /**
    * Retrieve a list of function parameter names from a method
    * Returns null if unable to read parameter names (i.e. bytecode not
    * built with debug).
    */
   public static String[] getParameterNamesFromDebugInfo(Method method)
   {
      // Don't worry about it if there are no params.
      int numParams = method.getParameterTypes().length;
      if (numParams == 0)
         return null;

      // get declaring class
      Class c = method.getDeclaringClass();

      // Don't worry about it if the class is a Java dynamic proxy
      if (Proxy.isProxyClass(c))
      {
         return null;
      }

      try
      {
         // get a parameter reader
         ParamReader pr = new ParamReader(c);
         // get the paramter names
         String[] names = pr.getParameterNames(method);
         return names;
      }
      catch (IOException e)
      {
         // log it and leave
         log.info(Messages.getMessage("error00") + ":" + e);
         return null;
      }
   }
}