/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the docs/licenses/apache-1.1.txt file.
 */
package org.jboss.axis;

/**
 * A simple implementation of AxisServiceConfig.
 *
 * @author Glen Daniels (gdaniels@apache.org)
 */
public class AxisServiceConfigImpl implements AxisServiceConfig
{
   private String methods;

   /**
    * Set the allowed method names.
    */
   public void setAllowedMethods(String methods)
   {
      this.methods = methods;
   }

   /**
    * Get the allowed method names.
    *
    * @return a space-delimited list of method names which may be called
    *         via SOAP.
    */
   public String getAllowedMethods()
   {
      return methods;
   }
}
