/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.xml.rpc;

import org.jboss.util.id.SerialVersion;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class ServiceException extends Exception
{
   /** @since 4.0.2 */
   static final long serialVersionUID;
   static
   {
      if (SerialVersion.version == SerialVersion.LEGACY)
         serialVersionUID = -4042547292194127311L;
      else
         serialVersionUID = -6582148924441189775L;
   }

   public ServiceException()
   {
   }

   public ServiceException(String message)
   {
      super(message);
   }

   public ServiceException(String message, Throwable cause)
   {
      super(message, cause);
   }

   public ServiceException(Throwable cause)
   {
      super(cause);
   }

   public Throwable getLinkedCause()
   {
      return super.getCause();
   }
}
