/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.xml.rpc;

import org.jboss.util.id.SerialVersion;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class JAXRPCException extends RuntimeException
{
   /** @since 4.0.2 */
   static final long serialVersionUID;
   static
   {
      if (SerialVersion.version == SerialVersion.LEGACY)
         serialVersionUID = 2012915834079496799L;
      else
         serialVersionUID = 5213579554532711730L;
   }

   public JAXRPCException()
   {
   }

   public JAXRPCException(String message)
   {
      super(message);
   }

   public JAXRPCException(String message, Throwable cause)
   {
      super(message, cause);
   }

   public JAXRPCException(Throwable cause)
   {
      super(cause);
   }

   public Throwable getLinkedCause()
   {
      return super.getCause();
   }
}
