/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.security.jacc;

/** JACC interface which defines the methods that must be implemented by
 * handlers that are to be registered and activated by PolicyContexts
 * 
 * @see http://java.sun.com/j2ee/1.4/docs/api/
 * 
 * @author Scott.Stark@jboss.org
 * @author Ron Monzillo, Gary Ellison (javadoc)
 * @version $Revision:1$
 */
public interface PolicyContextHandler
{
   /** Used by the PolicyContext class to activate the handler and obtain from
    * it the context object identified by the given key. In addition
    * to the key, the handler will be activated with the handler data value
    * associated within the PolicyContext class with the thread on which the
    * call to this method is made.
    *
    * @param key - a non-null key indicating which context to return.
    * @param data - the possiblye null handler data Object associated with the
    * thread on which the call to this method has been made.
    * @return The container and handler specific Object  containing the desired
    * context. A null value may be returned if the value of the corresponding
    * context is null.
    * @throws PolicyContextException
    */ 
   public Object getContext(String key, Object data)
      throws PolicyContextException;

   /** Get the keys identifying the context objects supported by this handlers
    * getContext(String, Object) method.
    * The value of each key supported by a handler must be a non-null String
    * value.
    * 
    * @return the list of supported context object keys.
    * @throws PolicyContextException
    */ 
   public String[] getKeys()
      throws PolicyContextException;

   /** Query the handler to see if its getContext(String, Object) method
    * supports the given key.
    * 
    * @param key - the context object key to check.
    * @return true if the key is supported, false otherwise
    * @throws PolicyContextException
    */ 
   public boolean supports(String key)
      throws PolicyContextException;
}
