/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

/**
 * Operations for lifecycle management and message endpoint configuration.
 * Implementations of this interface must be javabeans
 */
public interface ResourceAdapter
{
   /**
    * Used to bootstrap the resource adapter
    *
    * @param ctx the bootstrap context
    * @throws ResourceAdapterInternalException for a bootstrap failure
    */
   void start(BootstrapContext ctx) throws ResourceAdapterInternalException;

   /**
    * Used to stop the resource adapter
    */
   void stop();
   
   /**
    * Activates the endpoint factory
    *
    * @param endpointFactory the endpoint factory
    * @param spec the activation spec
    * @throws ResourceException for a generic error
    * @throws NotSupportedException for incorrect activation
    */
   void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException;
   
   /**
    * Deactivates the endpoint
    *
    * @param endpointFactory the endpoint factory
    * @param spec the activation spec
    */
   void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec);
   
   /**
    * Called by the application server during recovery
    *
    * @param specs the activation specs
    * @return the XAResources used to perform the recovery
    * @throws ResourceException for a generic error
    */
   XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException;
}