/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tm.iiop.client;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.UserTransaction;

import org.omg.CORBA.BAD_PARAM;

import org.jboss.logging.Logger;
import org.jboss.tm.iiop.TransactionFactoryExtHelper;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
     
/**
 *  This is an object factory for producing client-side UserTransactions
 *  for standalone RMI/IIOP clients.
 *      
 *  @author <a href="mailto:osh@sparre.dk">Ole Husgaard</a>
 *  @author  <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 *  @version $Revision:1$
 */
public class IIOPClientUserTransactionObjectFactory
      implements ObjectFactory
{
   private static final Logger log = 
      Logger.getLogger(IIOPClientUserTransactionObjectFactory.class);
   private static final boolean traceEnabled = log.isTraceEnabled();

   /**
    *  The <code>UserTransaction</code> this factory will return.
    *  This is evaluated lazily in {@link #getUserTransaction()}.
    */
   private static UserTransaction userTransaction = null;

   /**
    *  Get the <code>UserTransaction</code> this factory will return.
    *  This may return a cached value from a previous call.
    */
   private static UserTransaction getUserTransaction()
   {
      if (userTransaction == null) 
      {
         // See if we have a local TM
         try 
         {
            new InitialContext().lookup("java:/TransactionManager");
            
            // We execute in the server.
            userTransaction = ServerVMClientUserTransaction.getSingleton();
         } 
         catch (NamingException ex) 
         {
            // We execute in a stand-alone client.
            userTransaction = IIOPClientUserTransaction.getSingleton();
         }
      }
      return userTransaction;
   }
   
   public Object getObjectInstance(Object obj, Name name,
                                   Context nameCtx, Hashtable environment)
      throws Exception
   {

      if (traceEnabled) 
         log.trace("getObjectInstance: obj=" + obj +
                   "\n                  name=" + name +
                   "\n               nameCtx= " + nameCtx);
      
      if (!name.toString().equals("UserTransaction"))
         return null;
      try 
      {
         TransactionFactoryExtHelper.narrow(obj);
      }
      catch (BAD_PARAM e)
      {
         return null;
      }
      return getUserTransaction();
   }
}

