/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.proxy.ejb;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

/**
 * A ForeignTransaction, a marker for when we would have to import a
 * transaction from another vendor. Which we don't do at the moment.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ForeignTransaction implements Transaction
{
   public static final ForeignTransaction instance = new ForeignTransaction();
   
   private ForeignTransaction()
   {
   }
   
   public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException,
         SecurityException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public void rollback() throws IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public void setRollbackOnly() throws IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public int getStatus() throws SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException,
         SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }
}
