/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.iiop.csiv2;

/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

import javax.management.ObjectName;

import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CSI.IdentityToken;

/**
 * This class implements <code>SASCurrent</code>.
 *
 * @author  <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 * @version $Revision:1$
 */

public class SASCurrentImpl
   extends LocalObject
   implements SASCurrent
{
   /** @since 4.0.1 */
   static final long serialVersionUID = 108332919461569666L;

   // Fields --------------------------------------------------------

   private SASTargetInterceptor serverInterceptor;
 
   // Initializer ---------------------------------------------------

   public void init(SASTargetInterceptor serverInterceptor)
   {
      this.serverInterceptor = serverInterceptor;
   }

   // SASCurrent operations -----------------------------------------
    
   public boolean context_received()
   {
      return serverInterceptor.sasContextReceived();
   }

   public boolean client_authentication_info_received()
   {
      return serverInterceptor.authenticationTokenReceived();
   }

   public byte[] get_incoming_username()
   {
      return serverInterceptor.getIncomingUsername();
   }

   public byte[] get_incoming_password()
   {
      return serverInterceptor.getIncomingPassword();
   }

   public byte[] get_incoming_target_name()
   {
      return serverInterceptor.getIncomingTargetName();
   }

   public IdentityToken get_incoming_identity()
   {
      return serverInterceptor.getIncomingIdentity();
   }


   public int get_incoming_identity_token_type()
   {
      return serverInterceptor.getIncomingIdentity().discriminator();
   }

   public byte[] get_incoming_principal_name()
   {
      return serverInterceptor.getIncomingPrincipalName();
   }

   public void reject_incoming_context()
   {
      serverInterceptor.rejectIncomingContext();
   }

}
