/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.deployment.spi;

// $Id:TargetModuleIDImpl.java,v 1.0, 2005-06-24 19:17:22Z, Robert Worsnop$

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import java.util.ArrayList;
import java.util.List;

/**
 * A TargetModuleID interface represents a unique identifier for a deployed application module.
 * A deployable application module can be an EAR, JAR, WAR or RAR file. A TargetModuleID can represent
 * a root module or a child module. A root module TargetModuleID has no parent. It represents a deployed EAR
 * file or stand alone module. A child module TargetModuleID represents a deployed sub module of a J2EE application.
 * A child TargetModuleID has only one parent, the super module it was bundled and deployed with.
 * The identifier consists of the target name and the unique identifier for the deployed application module.
 * 
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 */
public class TargetModuleIDImpl implements TargetModuleID
{

   private TargetModuleIDImpl parentModuleID;
   private List childModuleIDs = new ArrayList();
   private JBossTarget target;
   private String moduleID;
   private ModuleType moduleType;
   private boolean isRunning;

   /**
    * Construct a new target module
    */
   public TargetModuleIDImpl(Target target, String moduleID, TargetModuleID parentModuleID, boolean isRunning)
   {
      this.target = (JBossTarget) target;
      this.moduleID = moduleID;
      this.parentModuleID = (TargetModuleIDImpl) parentModuleID;
      this.isRunning = isRunning;
   }

   /**
    * True if the module is running.
    */
   public boolean isRunning()
   {
      return isRunning;
   }

   /**
    * Get this modules type.
    */
   public ModuleType getModeType()
   {
      if (moduleType != null)
      {
         return moduleType;
      }

      if (moduleID.endsWith(".war"))
      {
         moduleType = ModuleType.WAR;
      }
      else if (moduleID.endsWith(".ear"))
      {
         moduleType = ModuleType.EAR;
      }
      else if (moduleID.endsWith(".jar"))
      {
         moduleType = ModuleType.EJB;
      }
      else if (moduleID.endsWith(".rar"))
      {
         moduleType = ModuleType.RAR;
      }
      else
      {
         throw new UnsupportedOperationException("Cannot obtain module type for: " + moduleID);
      }

      return moduleType;
   }

   // TargetModuleID interface *****************************************************************************************

   /**
    * Get the target
    * 
    * @return the target
    */
   public Target getTarget()
   {
      return target;
   }

   /**
    * Get the module id
    * 
    * @return the id
    */
   public String getModuleID()
   {
      return moduleID;
   }

   /**
    * The URL for a web module
    * 
    * @return the url
    */
   public String getWebURL()
   {
      return null;  //[todo] implement method
   }

   /**
    * Return the identifier of this module
    * 
    * @return the identifier
    */
   public String toString()
   {
      return "[" + target.getHostName() + "," + moduleID + "]";
   }

   /**
    * The parent of this module
    * 
    * @return the parent or null if there is no parent
    */
   public TargetModuleID getParentTargetModuleID()
   {
      return parentModuleID;
   }

   /**
    * Get the child modules
    * 
    * @return an array of child modules or null if there are no children
    */
   public TargetModuleID[] getChildTargetModuleID()
   {
      TargetModuleID[] idarr = new TargetModuleID[childModuleIDs.size()];
      childModuleIDs.toArray(idarr);
      return idarr;
   }

}
