/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.deployment.spi;

// $Id:JBossTarget.java,v 1.0, 2005-06-24 19:09:10Z, Robert Worsnop$

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;

/**
 * A Target interface represents a single logical core server of one instance of a J2EE platform product.
 * It is a designator for a server and the implied location to copy a configured application for the server to access.
 * 
 * @author thomas.diesler@jboss.org
 * @author Scott.Stark@jboss.com
 * @version $Revision:1$
 */
public interface JBossTarget extends Target
{
   /**
    * Get the target's host name
    */
   abstract String getHostName();

   /**
    * Deploy a given module
    */
   abstract void deploy(TargetModuleID targetModuleID) throws Exception;

   /**
    * Start a given module
    */
   abstract void start(TargetModuleID targetModuleID) throws Exception;

   /**
    * Stop a given module
    */
   abstract void stop(TargetModuleID targetModuleID) throws Exception;

   /**
    * Undeploy a given module
    */
   abstract void undeploy(TargetModuleID targetModuleID) throws Exception;

   /**
    * Retrieve the list of all J2EE application modules running or not running on the identified targets.
    */
   TargetModuleID[] getAvailableModules(ModuleType moduleType) throws TargetException;
}
