/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.console.twiddle.command;

import javax.management.MBeanParameterInfo;

/** A representation of an mbean operation that compares ops based on
 * the name and the operation parameters.
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class MBeanOp
{
   private String name;
   private String[] sig;

   public MBeanOp(String name, MBeanParameterInfo[] params)
   {
      this.name = name;
      int count = params != null ? params.length : 0;
      sig = new String[count];
      for(int n = 0; n < count; n ++)
      {
         MBeanParameterInfo p = params[n];
         sig[n] = p.getType();
      }
   }
   public MBeanOp(String name, int count)
   {
      this.name = name;
      sig = new String[count];
      for(int n = 0; n < count; n ++)
      {
         sig[n] = String.class.getName();
      }
   }

   public String getName()
   {
      return name;
   }
   public String[] getSignature()
   {
      return sig;
   }
   public int getArgCount()
   {
      return sig.length;
   }
   public String getArgType(int n)
   {
      return sig[n];
   }

   public boolean equals(Object obj)
   {
      MBeanOp op = (MBeanOp) obj;
      if( op.name.equals(name) == false || sig.length != op.sig.length )
         return false;
      for(int n = 0; n < sig.length; n ++)
      {
         if( sig[n].equals(op.sig[n]) == false )
            return false;
      }
      return true;
   }

   public int hashCode()
   {
      int hashCode = name.hashCode();
      for(int n = 0; n < sig.length; n ++)
      {
         hashCode += sig[n].hashCode();
      }
      return hashCode;
   }
}
