/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.HashSet;

/**
 * Transaction Support meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class TransactionSupportMetaData implements Serializable
{
   // Constants -----------------------------------------------------
   static final long serialVersionUID = 691622093079125748L;
   
   /** No transaction */
   public static final int NoTransaction = 0;

   /** Local transaction */
   public static final int LocalTransaction = 1;

   /** XA transaction */
   public static final int XATransaction = 2;
   
   // Attributes ----------------------------------------------------
   
   /** The transaction support */
   private int transactionSupport;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the transaction support
    * 
    * @return the transaction support
    */
   public int getTransactionSupport()
   {
      return transactionSupport;
   }

   /**
    * Set the transaction support
    * 
    * @param transactionSupport the transaction support
    */
   public void setTransactionSupport(int transactionSupport)
   {
      this.transactionSupport = transactionSupport;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("TransactionSupportMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      if (transactionSupport == NoTransaction)
         buffer.append("[transactionSupport=NoTransaction]");
      else if (transactionSupport == LocalTransaction)
         buffer.append("[transactionSupport=LocalTransaction]");
      else if (transactionSupport == XATransaction)
         buffer.append("[transactionSupport=XATransaction]");
      else 
         buffer.append("[transactionSupport=Unknown/Error]");
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
