/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * Message listener meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class MessageListenerMetaData implements Serializable
{
   // Constants -----------------------------------------------------
   static final long serialVersionUID = -3196418073906964586L;
   // Attributes ----------------------------------------------------
   
   /** The message listener type */
   private String type;
   
   /** The activation spec type */
   private String asType;
   
   /** The required properties */
   private HashSet requiredProperties = new HashSet();
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the message listener type
    * 
    * @return the message listener type
    */
   public String getType()
   {
      return type;
   }

   /**
    * Set the message listener type
    * 
    * @param type the message listener type
    */
   public void setType(String type)
   {
      this.type = type;
   }

   /**
    * Get the activation spec type
    * 
    * @return the activation spec type
    */
   public String getActivationSpecType()
   {
      return asType;
   }

   /**
    * Set the activation spec type
    * 
    * @param type the activation spec type
    */
   public void setActivationSpecType(String type)
   {
      this.asType = type;
   }
   
   /**
    * Add a required config property
    * 
    * @param rcpmd the required config property
    */
   public void addRequiredConfigProperty(RequiredConfigPropertyMetaData rcpmd)
   {
      requiredProperties.add(rcpmd);
   }

   /**
    * Get the required properties
    * 
    * @return the required config properties
    */
   public Collection getRequiredConfigProperties()
   {
      return requiredProperties;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("MessageListenerMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[type=").append(type);
      buffer.append(" activationSpecType=").append(asType);
      buffer.append(" requiredProperties=").append(requiredProperties);
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
