/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Locale;

/**
 * Description meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class DescriptionMetaData implements Serializable
{
   // Constants -----------------------------------------------------
   static final long serialVersionUID = -3100028904830435509L;
   // Attributes ----------------------------------------------------

   /** The language */
   private String lang;
   
   /** The description */
   private String description;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
    * Create a new description meta data using the default langugage
    */
   public DescriptionMetaData()
   {
      this(null);
   }

   /**
    * Create a new description meta data
    * 
    * @parm lang the language
    */
   public DescriptionMetaData(String lang)
   {
      if (lang == null)
         this.lang = Locale.getDefault().getLanguage();
      else
         this.lang = lang;
   }
   
   // Public --------------------------------------------------------

   /**
    * Get the language
    * 
    * @return the language
    */
   public String getLanguage()
   {
      return lang;
   }

   /**
    * Get the description
    * 
    * @return the description
    */
   public String getDescription()
   {
      return description;
   }

   /**
    * Set the description
    * 
    * @param description the description
    */
   public void setDescription(String description)
   {
      this.description = description;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("DescriptionMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[language=").append(lang);
      if (description != null)
         buffer.append(" description=").append(description);
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
