/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;

/**
 * Admin object meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class AdminObjectMetaData extends ConfigPropertyMetaDataContainer
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The admin object interface class */
   private String adminObjectInterfaceClass;

   /** The admin object implementation class */
   private String adminObjectImplementationClass;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the admin object interface class
    * 
    * @return the admin object interface class
    */
   public String getAdminObjectInterfaceClass()
   {
      return adminObjectInterfaceClass;
   }

   /**
    * Set the admin object interface class
    * 
    * @param adminObjectInterfaceClass the class name
    */
   public void setAdminObjectInterfaceClass(String adminObjectInterfaceClass)
   {
      this.adminObjectInterfaceClass = adminObjectInterfaceClass;
   }

   /**
    * Get the admin object implementation class
    * 
    * @return the admin object implementation class
    */
   public String getAdminObjectImplementationClass()
   {
      return adminObjectImplementationClass;
   }

   /**
    * Set the admin object implementation class
    * 
    * @param adminObjectImplementationClass the class name
    */
   public void setAdminObjectImplementationClass(String adminObjectImplementationClass)
   {
      this.adminObjectImplementationClass = adminObjectImplementationClass;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("AdminObjectMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[adminObjectInterfaceClass=").append(adminObjectInterfaceClass);
      buffer.append(" adminObjectImplementationClass=").append(adminObjectImplementationClass);
      buffer.append(" properties=").append(getProperties());
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
