/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.resource.adapter.jms.inflow;

import javax.jms.Message;
import javax.naming.Context;

/**
 * An interface for DLQ Handling
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public interface DLQHandler
{
   // Constants -----------------------------------------------------

   /** JMS property name holding original destination. */
   public static final String JBOSS_ORIG_DESTINATION = "JBOSS_ORIG_DESTINATION";

   /** JMS property name holding original JMS message id. */
   public static final String JBOSS_ORIG_MESSAGEID = "JBOSS_ORIG_MESSAGEID";

   // Public --------------------------------------------------------

   /**
    * Set up the DLQ
    * 
    * @param activation the activation
    * @param context the naming context
    * @throws Exception for any error
    */
   void setup(JmsActivation activation, Context ctx) throws Exception;

   /**
    * Tear down the DLQ
    */
   void teardown();
   
   /**
    * Check whether the DLQ should handle the message
    * 
    * @param message the message about to be delivered
    * @return true if the message is handled and should not be delivered
    */
   boolean handleRedeliveredMessage(Message msg);
   
   /**
    * Notification that the message was delivered
    * 
    * @param message the message that was delivered
    */
   void messageDelivered(Message msg);
   
   // Inner classes -------------------------------------------------
}
