/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.resource.adapter.jms;

import java.io.Serializable;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;

/**
 * A wrapper for a message
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class JmsObjectMessage extends JmsMessage implements ObjectMessage
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new wrapper
    * 
    * @param message the message
    * @param session the session
    */
   public JmsObjectMessage(ObjectMessage message, JmsSession session)
   {
      super(message, session);
   }
   
   // Public --------------------------------------------------------
   
   // ObjectMessage implementation ----------------------------------

   public Serializable getObject() throws JMSException
   {
      return ((ObjectMessage) message).getObject();
   }
   
   public void setObject(Serializable object) throws JMSException
   {
      ((ObjectMessage) message).setObject(object);
   }
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
