/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.resource.adapter.jms;

import javax.jms.Message;
import javax.jms.MessageListener;

/**
 * A wrapper for a message listener
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class JmsMessageListener implements MessageListener
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------

   /** The message listener */
   MessageListener listener;
   
   /** The consumer */
   JmsMessageConsumer consumer;
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new wrapper
    * 
    * @param listener the listener
    * @param consumer the consumer
    */
   public JmsMessageListener(MessageListener listener, JmsMessageConsumer consumer)
   {
      this.listener = listener;
      this.consumer = consumer;
   }
   
   // Public --------------------------------------------------------
   
   // MessageListener implementation --------------------------------

   public void onMessage(Message message)
   {
      message = consumer.wrapMessage(message);
      listener.onMessage(message);
   }
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
