/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
import org.jboss.util.NestedRuntimeException;

/**
 * Implements check valid connection sql 
 * Requires MySQL driver 3.1.8 or later.  This should work on just about any
 * version of the database itself but will only be "fast" on version 3.22.1 and
 * later.  Prior to that version it just does "SELECT 1" anyhow.
 *
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @author <a href="mailto:acoliver ot jbosss dat org">Andrew C. Oliver</a>
 * @version $Revision:1$
 */
public class MySQLValidConnectionChecker
   implements ValidConnectionChecker, Serializable
{
   private static final long serialVersionUID = -2227528634302168878L;

   private static final Logger log = Logger.getLogger(MySQLValidConnectionChecker.class);

   private Method ping;

   // The timeout (apparently the timeout is ignored?)
   private static Object[] params = new Object[] {  };

   public MySQLValidConnectionChecker()
   {
      try
      {
         Class oracleConnection = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Connection");
         ping = oracleConnection.getMethod("ping", new Class[] { });
      }
      catch (Exception e)
      {
         throw new NestedRuntimeException("Unable to resolve ping method:", e);
      }
   }

   public SQLException isValidConnection(Connection c)
   {
      try
      {
         Integer status = (Integer) ping.invoke(c, params);

         // Error
         if (status.intValue() < 0)
            return new SQLException("ping failed status=" + status);
      }
      catch (Exception e)
      {
         // What do we do here? Assume it is a misconfiguration
         log.warn("Unexpected error in ping", e);
      }

      // OK
      return null;
   }
}
