/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.io.Serializable;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision:1$
 */
public class SerializableParameterMetaData implements ParameterMetaData, Serializable
{
   /** @since 1.1 */
   static final long serialVersionUID = -6601828413479683906L;
   int parameterCount = 0;

   public SerializableParameterMetaData(ParameterMetaData pMetaData) throws SQLException
   {
      this.parameterCount = pMetaData.getParameterCount();
   }

   /**
    * Retrieves the number of parameters in the <code>PreparedStatement</code>
    * object for which this <code>ParameterMetaData</code> object contains
    * information.
    *
    * @return the number of parameters
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public int getParameterCount() throws SQLException
   {
      return parameterCount;
   }

   /**
    * Retrieves the designated parameter's mode.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return mode of the parameter; one of
    *         <code>ParameterMetaData.parameterModeIn</code>,
    *         <code>ParameterMetaData.parameterModeOut</code>, or
    *         <code>ParameterMetaData.parameterModeInOut</code>
    *         <code>ParameterMetaData.parameterModeUnknown</code>.
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public int getParameterMode(int param) throws SQLException
   {
      return 0;
   }

   /**
    * Retrieves the designated parameter's SQL type.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return SQL type from <code>java.sql.Types</code>
    * @throws java.sql.SQLException if a database access error occurs
    * @see java.sql.Types
    * @since 1.4
    */
   public int getParameterType(int param) throws SQLException
   {
      return 0;
   }

   /**
    * Retrieves the designated parameter's number of decimal digits.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return precision
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public int getPrecision(int param) throws SQLException
   {
      return 0;
   }

   /**
    * Retrieves the designated parameter's number of digits to right of the decimal point.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return scale
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public int getScale(int param) throws SQLException
   {
      return 0;
   }

   /**
    * Retrieves whether null values are allowed in the designated parameter.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return the nullability status of the given parameter; one of
    *         <code>ParameterMetaData.parameterNoNulls</code>,
    *         <code>ParameterMetaData.parameterNullable</code>, or
    *         <code>ParameterMetaData.parameterNullableUnknown</code>
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public int isNullable(int param) throws SQLException
   {
      return 0;
   }

   /**
    * Retrieves whether values for the designated parameter can be signed numbers.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return <code>true</code> if so; <code>false</code> otherwise
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public boolean isSigned(int param) throws SQLException
   {
      return false;
   }

   /**
    * Retrieves the fully-qualified name of the Java class whose instances
    * should be passed to the method <code>PreparedStatement.setObject</code>.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return the fully-qualified name of the class in the Java programming
    *         language that would be used by the method
    *         <code>PreparedStatement.setObject</code> to set the value
    *         in the specified parameter. This is the class name used
    *         for custom mapping.
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public String getParameterClassName(int param) throws SQLException
   {
      return null;
   }

   /**
    * Retrieves the designated parameter's database-specific type name.
    *
    * @param param the first parameter is 1, the second is 2, ...
    * @return type the name used by the database. If the parameter type is
    *         a user-defined type, then a fully-qualified type name is returned.
    * @throws java.sql.SQLException if a database access error occurs
    * @since 1.4
    */
   public String getParameterTypeName(int param) throws SQLException
   {
      return null;
   }
}


