/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.ha.jndi;

import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMIClientSocketFactory;

import org.jboss.ha.framework.server.HARMIServerImpl;
import org.jboss.ha.framework.interfaces.RoundRobin;
import org.jnp.interfaces.Naming;

/** Management Bean for HA-JNDI service for the legacy version that is coupled
 * to the RMI/JRMP protocol. The DetachedHANamingService should be used with
 * the approriate detached invoker service.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class HANamingService
   extends DetachedHANamingService
   implements HANamingServiceMBean
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   /** An optional custom client socket factory */
   protected RMIClientSocketFactory clientSocketFactory;
   /** An optional custom server socket factory */
   protected RMIServerSocketFactory serverSocketFactory;
   /** The class name of the optional custom client socket factory */
   protected String clientSocketFactoryName;
   /** The class name of the optional custom server socket factory */
   protected String serverSocketFactoryName;
   /** The RMI port on which the Naming implementation will be exported. The
    default is 0 which means use any available port. */
   protected int rmiPort = 0;
   HARMIServerImpl rmiserver;

   // Public --------------------------------------------------------

   public HANamingService()
   {
      // for JMX
   }

   public void setRmiPort(int p)
   {
      rmiPort = p;
   }
   public int getRmiPort()
   {
      return rmiPort;
   }
   
   public String getClientSocketFactory()
   {
      return serverSocketFactoryName;
   }
   public void setClientSocketFactory(String factoryClassName)
      throws ClassNotFoundException, InstantiationException, IllegalAccessException
   {
      this.clientSocketFactoryName = factoryClassName;
      ClassLoader loader = Thread.currentThread().getContextClassLoader();
      Class clazz = loader.loadClass(clientSocketFactoryName);
      clientSocketFactory = (RMIClientSocketFactory) clazz.newInstance();
   }
   
   public String getServerSocketFactory()
   {
      return serverSocketFactoryName;
   }
   public void setServerSocketFactory(String factoryClassName)
      throws ClassNotFoundException, InstantiationException, IllegalAccessException
   {
      this.serverSocketFactoryName = factoryClassName;
      ClassLoader loader = Thread.currentThread().getContextClassLoader();
      Class clazz = loader.loadClass(serverSocketFactoryName);
      serverSocketFactory = (RMIServerSocketFactory) clazz.newInstance();
   }

   protected void stopService() throws Exception
   {
      super.stopService();
      // Unexport server
      log.debug("destroy ha rmiserver");
      this.rmiserver.destroy ();
   }

   protected Naming getNamingProxy() throws Exception
   {
      rmiserver = new HARMIServerImpl(partition, "HAJNDI", Naming.class,
         theServer, rmiPort, clientSocketFactory, serverSocketFactory, bindAddress);
      Naming proxy = (Naming) rmiserver.createHAStub(new RoundRobin());
      return proxy;
   }
}
