// $Id:TimeoutException.java,v 1.0, 2005-06-24 19:17:53Z, Robert Worsnop$

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.lock;

import org.jboss.cache.CacheException;

import java.util.List;


/**
 * Thrown when a timeout occurred. used by operations with timeouts, e.g. lock
 * acquisition, or waiting for responses from all members.
 *
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a>.
 * @version $Revision:1$
 *          <p/>
 *          <p><b>Revisions:</b>
 *          <p/>
 *          <p>Dec 28 2002 Bela Ban: first implementation
 */
public class TimeoutException extends CacheException
{
   List failed_members = null;

   public TimeoutException()
   {
      super();
   }

   public TimeoutException(List failed_members)
   {
      super();
      this.failed_members = failed_members;
   }

   public TimeoutException(String msg)
   {
      super(msg);
   }

   public TimeoutException(String msg, Throwable cause)
   {
      super(msg, cause);
   }

   public String toString()
   {
      String retval = super.toString();
      if (failed_members != null)
         retval += ", failed_members=" + failed_members;
      return retval;
   }
}
