/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.interceptors;

import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

/**
 * When a call returns, unlocks all locks held by the current thread in the LockTable. This is a no-op if a transaction
 * is used.
 * @author Bela Ban
 * @version $Id:UnlockInterceptor.java,v 1.0, 2005-06-24 19:18:34Z, Robert Worsnop$
 */
public class UnlockInterceptor extends Interceptor {
   HashMap lock_table=null;
   TransactionManager tx_mgr=null;

   public void setCache(TreeCache cache) {
      super.setCache(cache);
      tx_mgr=cache.getTransactionManager();
      lock_table=cache.getLockTable();
   }



   public Object invoke(MethodCall m) throws Throwable {
      Transaction       tx;

      try {
         return super.invoke(m);
      }
      finally {
         if(tx_mgr != null && (tx=tx_mgr.getTransaction()) != null && isValid(tx)) {
            ; // don't do anything; we have a transaction
         }
         else { // no TX
            List locks=(List)lock_table.get(Thread.currentThread());
            if(locks != null) {
               releaseLocks(locks);
               lock_table.remove(Thread.currentThread());
            }
         }
      }
   }





   private void releaseLocks(List locks) {
      IdentityLock lock;
      // Release the locks backwards (bottom-up in the tree)
      // Note that the lock could have been released already so don't panic
      if(locks != null) {
         for(ListIterator it=locks.listIterator(locks.size()); it.hasPrevious();) {
            lock=(IdentityLock)it.previous();
            if(log.isTraceEnabled())
               log.trace("releasing lock for " + lock.getFqn() + ": " + lock);
            lock.release(Thread.currentThread());
            // it.remove();
         }
         locks.clear();
      }
   }


}
