/*
 * Generated file - Do not edit!
 */
package org.jboss.cache.aop;

/**
 * MBean interface.
 * @author Harald Gliebe
 * @author Ben Wang
 */
public interface TreeCacheAopMBean extends org.jboss.cache.TreeCacheMBean {

   /**
    * Over-ride to make sure we are using an eviction policy specific to aop.
    */
  void setEvictionPolicyClass(java.lang.String eviction_policy_class) ;

   /**
    * Insert an aop-enabled object into the cache. It will also recursively put the any sub-object that is declared as aop-capable (i.e., in <code>jboss-aop.xml</code>). Note that <code>List</code>, <code>Map</code>, <code>Set</code> attributes are aop-enabled, by default, as well.
    * @param fqn The fqn string name to associate with the object in the cache.
    * @param obj aop-enabled object to be inerted into the cache. If null, it will nullify the fqn node.
    * @param obj Return the previous content under fqn.
    * @throws CacheException
    */
  java.lang.Object putObject(java.lang.String fqn,java.lang.Object obj) throws org.jboss.cache.CacheException;

   /**
    * Insert an aop-enabled object into the cache. It will also recursively put the any sub-object that is declared as aop-capable (i.e., in <code>jboss-aop.xml</code>). Note that <code>List</code>, <code>Map</code>, <code>Set</code> attributes are aop-enabled, by default, as well.
    * @param fqn The fqn instance to associate with the object in the cache.
    * @param obj aop-enabled object to be inerted into the cache. If null, it will nullify the fqn node.
    * @param obj Return the previous content under fqn.
    * @throws CacheException
    */
  java.lang.Object putObject(org.jboss.cache.Fqn fqn,java.lang.Object obj) throws org.jboss.cache.CacheException;

   /**
    * Retrieve the aop-enabled object from the cache.
    * @param fqn String name that associates with this node.
    * @return Current content value. Null if does not exist.
    * @throws CacheException
    */
  java.lang.Object getObject(java.lang.String fqn) throws org.jboss.cache.CacheException;

   /**
    * Retrieve the aop-enabled object from the cache. Return null if object does not exist in the cache.
    * @param fqn Instance that associates with this node.
    * @return Current content value. Null if does not exist.
    * @throws CacheException
    */
  java.lang.Object getObject(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

   /**
    * Remove aop-enabled object from the cache.
    * @param fqn String name that associates with this node.
    * @return Value object from this node.
    * @throws CacheException
    */
  java.lang.Object removeObject(java.lang.String fqn) throws org.jboss.cache.CacheException;

   /**
    * Remove aop-enabled object from the cache.
    * @param fqn Instance that associates with this node.
    * @return Original value object from this node.
    * @throws CacheException
    */
  java.lang.Object removeObject(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

   /**
    * Obtain a cache aop type for user to traverse the defined "primitive" types in aop.
    * @param clazz The original pojo class
    * @return CachedType
    */
  org.jboss.cache.aop.CachedType getCachedType(java.lang.Class clazz) ;

  java.lang.Object _put(org.jboss.cache.GlobalTransaction tx,org.jboss.cache.Fqn fqn,java.lang.Object key,java.lang.Object value,boolean create_undo_ops) throws org.jboss.cache.CacheException;

   /**
    * Override to provide aop specific eviction. <p> Called by eviction policy provider. Note that eviction is done only in local mode, that is, it doesn't replicate the node removal. This is will cause the replcation nodes not synchronizing, but it is ok since user is supposed to add the node again when get is null. After that, the contents will be in sync.
    * @param fqn Will remove everythign assoicated with this fqn.
    * @throws CacheException    */
  void evict(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

}
