/*
 * Generated file - Do not edit!
 */
package org.jboss.cache;

/**
 * MBean interface.
 * @author Bela Ban
 * @author Ben Wang
 */
public interface TreeCacheMBean extends org.jboss.system.ServiceMBean {

  java.lang.Object getLocalAddress() ;

  java.util.Vector getMembers() ;

  boolean isCoordinator() ;

   /**
    * Get the name of the replication group
    */
  java.lang.String getClusterName() ;

   /**
    * Set the name of the replication group
    */
  void setClusterName(java.lang.String name) ;

   /**
    * Get the cluster properties (e.g. the protocol stack specification in case of JGroups)
    */
  java.lang.String getClusterProperties() ;

   /**
    * Set the cluster properties. If the cache is to use the new properties, it has to be redeployed
    * @param cluster_props The properties for the cluster (JGroups)
    */
  void setClusterProperties(java.lang.String cluster_props) ;

   /**
    * Dumps the contents of the TransactionTable
    * @return 
    */
  java.lang.String dumpTransactionTable() ;

  boolean getDeadlockDetection() ;

  void setDeadlockDetection(boolean dt) ;

  java.lang.String getInterceptorChain() ;

  java.util.List getInterceptors() ;

  java.lang.String getCacheLoaderClass() ;

  void setCacheLoaderClass(java.lang.String cache_loader_class) ;

  java.util.Properties getCacheLoaderConfig() ;

  void setCacheLoaderConfig(java.util.Properties cache_loader_config) ;

  org.jboss.cache.loader.CacheLoader getCacheLoader() ;

  void setCacheLoader(org.jboss.cache.loader.CacheLoader cache_loader) ;

  boolean getCacheLoaderShared() ;

  void setCacheLoaderShared(boolean shared) ;

  void setCacheLoaderPreload(java.lang.String list) ;

  java.lang.String getCacheLoaderPreload() ;

  void setCacheLoaderFetchPersistentState(boolean flag) ;

  boolean getCacheLoaderFetchPersistentState() ;

  void setCacheLoaderFetchTransientState(boolean flag) ;

  boolean getCacheLoaderFetchTransientState() ;

  boolean getSyncCommitPhase() ;

  void setSyncCommitPhase(boolean sync_commit_phase) ;

  boolean getSyncRollbackPhase() ;

  void setSyncRollbackPhase(boolean sync_rollback_phase) ;

   /**
    * Setup eviction policy configuration
    */
  void setEvictionPolicyConfig(org.w3c.dom.Element config) ;

   /**
    * Convert a list of elements to the JG property string
    */
  void setClusterConfig(org.w3c.dom.Element config) ;

   /**
    * Get the max time to wait until the initial state is retrieved. This is used in a replicating cache: when a new cache joins the cluster, it needs to acquire the (replicated) state of the other members to initialize itself. If no state has been received within <tt>timeout</tt> milliseconds, the map will be empty.
    * @return long Number of milliseconds to wait for the state. 0 means to wait forever.
    */
  long getInitialStateRetrievalTimeout() ;

   /**
    * Set the initial state transfer timeout (see {@link #getInitialStateRetrievalTimeout()})
    */
  void setInitialStateRetrievalTimeout(long timeout) ;

   /**
    * Returns the current caching mode. Valid values are <ul> <li>LOCAL <li>REPL_ASYNC <li>REPL_SYNC <ul>
    * @return String The caching mode
    */
  java.lang.String getCacheMode() ;

   /**
    * Sets the default caching mode)
    */
  void setCacheMode(java.lang.String mode) throws java.lang.Exception;

   /**
    * Returns the default max timeout after which synchronous replication calls return.
    * @return long Number of milliseconds after which a sync repl call must return. 0 means to wait forever
    */
  long getSyncReplTimeout() ;

   /**
    * Sets the default maximum wait time for synchronous replication to receive all results
    */
  void setSyncReplTimeout(long timeout) ;

  boolean getUseReplQueue() ;

  void setUseReplQueue(boolean flag) ;

  long getReplQueueInterval() ;

  void setReplQueueInterval(long interval) ;

  int getReplQueueMaxElements() ;

  void setReplQueueMaxElements(int max_elements) ;

   /**
    * Returns the transaction isolation level.
    */
  java.lang.String getIsolationLevel() ;

   /**
    * Set the transaction isolation level. This determines the locking strategy to be used
    */
  void setIsolationLevel(java.lang.String level) ;

  boolean getFetchStateOnStartup() ;

  void setFetchStateOnStartup(boolean flag) ;

   /**
    * Default max time to wait for a lock. If the lock cannot be acquired within this time, a LockingException will be thrown.
    * @return long Max number of milliseconds to wait for a lock to be acquired
    */
  long getLockAcquisitionTimeout() ;

   /**
    * Set the max time for lock acquisition. A value of 0 means to wait forever (not recomended). Note that lock acquisition timeouts may be removed in the future when we have deadlock detection.
    * @param timeout
    */
  void setLockAcquisitionTimeout(long timeout) ;

   /**
    * Returns the name of the cache eviction policy (must be an implementation of EvictionPolicy)
    * @return Fully qualified name of a class implementing the EvictionPolicy interface
    */
  java.lang.String getEvictionPolicyClass() ;

   /**
    * Sets the classname of the eviction policy
    */
  void setEvictionPolicyClass(java.lang.String eviction_policy_class) ;

   /**
    * Obtain eviction thread (if any) wake up interval in seconds
    */
  int getEvictionThreadWakeupIntervalSeconds() ;

   /**
    * Sets the TransactionManagerLookup object
    * @param l
    */
  void setTransactionManagerLookup(org.jboss.cache.TransactionManagerLookup l) ;

  java.lang.String getTransactionManagerLookupClass() ;

   /**
    * Sets the class of the TransactionManagerLookup impl. This will attempt to create an instance, and will throw an exception if this fails.
    * @param cl
    * @throws Exception
    */
  void setTransactionManagerLookupClass(java.lang.String cl) throws java.lang.Exception;

  javax.transaction.TransactionManager getTransactionManager() ;

  org.jboss.cache.TreeCache getInstance() ;

   /**
    * Fetch the group state from the current coordinator. If successful, this will trigger setState().
    */
  void fetchState(long timeout) throws org.jgroups.ChannelClosedException, org.jgroups.ChannelNotConnectedException;

  void addTreeCacheListener(org.jboss.cache.TreeCacheListener listener) ;

  void removeTreeCacheListener(org.jboss.cache.TreeCacheListener listener) ;

  void createService() throws java.lang.Exception;

  void destroyService() ;

  void startService() throws java.lang.Exception;

   /**
    * Loads the indicated Fqn, plus all parents recursively from the CacheLoader. If no CacheLoader is present, this is a no-op
    * @param fqn
    * @throws Exception
    */
  void load(java.lang.String fqn) throws java.lang.Exception;

  void stopService() ;

  java.util.Set getKeys(java.lang.String fqn) throws org.jboss.cache.CacheException;

  java.util.Set getKeys(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

   /**
    * Finds a node given its name and returns the value associated with a given key in its <code>data</code> map. Returns null if the node was not found in the tree or the key was not found in the hashmap.
    * @param fqn The fully qualified name of the node.
    * @param key The key.
    */
  java.lang.Object get(java.lang.String fqn,java.lang.Object key) throws org.jboss.cache.CacheException;

   /**
    * Finds a node given its name and returns the value associated with a given key in its <code>data</code> map. Returns null if the node was not found in the tree or the key was not found in the hashmap.
    * @param fqn The fully qualified name of the node.
    * @param key The key.
    */
  java.lang.Object get(org.jboss.cache.Fqn fqn,java.lang.Object key) throws org.jboss.cache.CacheException;

   /**
    * Checks whether a given node exists in the tree
    * @param fqn The fully qualified name of the node
    * @return boolean Whether or not the node exists
    */
  boolean exists(java.lang.String fqn) ;

   /**
    * Checks whether a given node exists in the tree. Does not acquire any locks in doing so (result may be dirty read)
    * @param fqn The fully qualified name of the node
    * @return boolean Whether or not the node exists
    */
  boolean exists(org.jboss.cache.Fqn fqn) ;

  boolean exists(java.lang.String fqn,java.lang.Object key) ;

   /**
    * Checks whether a given key exists in the given node. Does not interact with CacheLoader, so the behavior is different from {@link #get(Fqn,Object)}
    * @param fqn The fully qualified name of the node
    * @param key
    * @return boolean Whether or not the node exists
    */
  boolean exists(org.jboss.cache.Fqn fqn,java.lang.Object key) ;

   /**
    * Adds a new node to the tree and sets its data. If the node doesn not yet exist, it will be created. Also, parent nodes will be created if not existent. If the node already has data, then the new data will override the old one. If the node already existed, a nodeModified() notification will be generated. Otherwise a nodeCreated() motification will be emitted.
    * @param fqn The fully qualified name of the new node
    * @param data The new data. May be null if no data should be set in the node.
    */
  void put(java.lang.String fqn,java.util.Map data) throws org.jboss.cache.CacheException;

   /**
    * Adds a new node to the tree and sets its data. If the node doesn not yet exist, it will be created. Also, parent nodes will be created if not existent. If the node already has data, then the new data will override the old one. If the node already existed, a nodeModified() notification will be generated. Otherwise a nodeCreated() motification will be emitted.
    * @param fqn The fully qualified name of the new node
    * @param data The new data. May be null if no data should be set in the node.
    */
  void put(org.jboss.cache.Fqn fqn,java.util.Map data) throws org.jboss.cache.CacheException;

   /**
    * Adds a key and value to a given node. If the node doesn't exist, it will be created. If the node already existed, a nodeModified() notification will be generated. Otherwise a nodeCreated() motification will be emitted.
    * @param fqn The fully qualified name of the node
    * @param key The key
    * @param value The value
    * @return Object The previous value (if any), if node was present
    */
  java.lang.Object put(java.lang.String fqn,java.lang.Object key,java.lang.Object value) throws org.jboss.cache.CacheException;

   /**
    * Adds a key and value to a given node. If the node doesn't exist, it will be created. If the node already existed, a nodeModified() notification will be generated. Otherwise a nodeCreated() motification will be emitted.
    * @param fqn The fully qualified name of the node
    * @param key The key
    * @param value The value
    * @return Object The previous value (if any), if node was present
    */
  java.lang.Object put(org.jboss.cache.Fqn fqn,java.lang.Object key,java.lang.Object value) throws org.jboss.cache.CacheException;

   /**
    * Removes the node from the tree.
    * @param fqn The fully qualified name of the node.
    */
  void remove(java.lang.String fqn) throws org.jboss.cache.CacheException;

   /**
    * Removes the node from the tree.
    * @param fqn The fully qualified name of the node.
    */
  void remove(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

   /**
    * Called by eviction policy provider. Note that eviction is done only in local mode, that is, it doesn't replicate the node removal. This is will cause the replcation nodes not synchronizing, but it is ok since user is supposed to add the node again when get is null. After that, the contents will be in sync.
    * @param fqn Will remove everythign assoicated with this fqn.
    * @throws CacheException
    */
  void evict(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

   /**
    * Removes <code>key</code> from the node's hashmap
    * @param fqn The fullly qualified name of the node
    * @param key The key to be removed
    * @return The previous value, or null if none was associated with the given key
    */
  java.lang.Object remove(java.lang.String fqn,java.lang.Object key) throws org.jboss.cache.CacheException;

   /**
    * Removes <code>key</code> from the node's hashmap
    * @param fqn The fullly qualified name of the node
    * @param key The key to be removed
    * @return The previous value, or null if none was associated with the given key
    */
  java.lang.Object remove(org.jboss.cache.Fqn fqn,java.lang.Object key) throws org.jboss.cache.CacheException;

  void removeData(java.lang.String fqn) throws org.jboss.cache.CacheException;

  void removeData(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

   /**
    * Force-releases all locks in this node and the entire subtree
    * @param fqn
    */
  void releaseAllLocks(java.lang.String fqn) ;

   /**
    * Force-releases all locks in this node and the entire subtree
    * @param fqn
    */
  void releaseAllLocks(org.jboss.cache.Fqn fqn) ;

   /**
    * Prints a representation of the node defined by <code>fqn</code>. Output includes name, fqn and data.
    */
  java.lang.String print(java.lang.String fqn) ;

   /**
    * Prints a representation of the node defined by <code>fqn</code>. Output includes name, fqn and data.
    */
  java.lang.String print(org.jboss.cache.Fqn fqn) ;

   /**
    * Returns all children of a given node
    * @param fqn The fully qualified name of the node
    * @return Set A list of child names (as Strings)
    */
  java.util.Set getChildrenNames(java.lang.String fqn) throws org.jboss.cache.CacheException;

   /**
    * Returns all children of a given node
    * @param fqn The fully qualified name of the node
    * @return Set A list of child names (as Objects). Must <em>not</em> be modified because this would modify the underlying node directly (will throw an exception if modification is attempted). Returns null of the parent node was not found, or if there are no children
    */
  java.util.Set getChildrenNames(org.jboss.cache.Fqn fqn) throws org.jboss.cache.CacheException;

  java.lang.String toString() ;

  java.lang.String toString(boolean details) ;

  java.lang.String printDetails() ;

  java.lang.String printLockInfo() ;

   /**
    * Gets the number of read or write locks held across the entire tree
    * @return 
    */
  int getNumberOfLocksHeld() ;

   /**
    * Returns an <em>approximation</em> of the total number of nodes in the tree. Since this method doesn't acquire any locks, the number might be incorrect, or the method might even throw a ConcurrentModificationException
    * @return 
    */
  int getNumberOfNodes() ;

   /**
    * Returns an <em>approximation</em> of the total number of attributes in the tree. Since this method doesn't acquire any locks, the number might be incorrect, or the method might even throw a ConcurrentModificationException
    * @return 
    */
  int getNumberOfAttributes() ;

  java.util.List callRemoteMethods(java.util.Vector members,java.lang.reflect.Method method,java.lang.Object[] args,boolean synchronous,boolean exclude_self,long timeout) throws java.lang.Exception;

  java.util.List callRemoteMethods(java.util.Vector members,java.lang.String method_name,java.lang.Class[] types,java.lang.Object[] args,boolean synchronous,boolean exclude_self,long timeout) throws java.lang.Exception;

   /**
    * Does the real work. Needs to acquire locks if accessing nodes, depending on the value of <tt>locking</tt>. If run inside a transaction, needs to (a) add newly acquired locks to {@link TransactionEntry}'s lock list, (b) add nodes that were created to {@link TransactionEntry}'s node list and (c) create {@link Modification}s and add them to {@link TransactionEntry}'s modification list and (d) create compensating modifications to undo the changes in case of a rollback
    * @param fqn
    * @param data
    * @param create_undo_ops If true, undo operations will be created (default is true). Otherwise they will not be created (used by rollback()).
    */
  void _put(org.jboss.cache.GlobalTransaction tx,java.lang.String fqn,java.util.Map data,boolean create_undo_ops) throws org.jboss.cache.CacheException;

   /**
    * Does the real work. Needs to acquire locks if accessing nodes, depending on the value of <tt>locking</tt>. If run inside a transaction, needs to (a) add newly acquired locks to {@link TransactionEntry}'s lock list, (b) add nodes that were created to {@link TransactionEntry}'s node list and (c) create {@link Modification}s and add them to {@link TransactionEntry}'s modification list and (d) create compensating modifications to undo the changes in case of a rollback
    * @param fqn
    * @param data
    * @param create_undo_ops If true, undo operations will be created (default is true). Otherwise they will not be created (used by rollback()).
    */
  void _put(org.jboss.cache.GlobalTransaction tx,org.jboss.cache.Fqn fqn,java.util.Map data,boolean create_undo_ops) throws org.jboss.cache.CacheException;

   /**
    * Does the real work. Needs to acquire locks if accessing nodes, depending on the value of <tt>locking</tt>. If run inside a transaction, needs to (a) add newly acquired locks to {@link TransactionEntry}'s lock list, (b) add nodes that were created to {@link TransactionEntry}'s node list and (c) create {@link Modification}s and add them to {@link TransactionEntry}'s modification list and (d) create compensating modifications to undo the changes in case of a rollback
    * @param fqn
    * @param data
    * @param create_undo_ops If true, undo operations will be created (default is true).
    * @param erase_contents Clear the existing hashmap before putting the new data into it Otherwise they will not be created (used by rollback()).
    */
  void _put(org.jboss.cache.GlobalTransaction tx,org.jboss.cache.Fqn fqn,java.util.Map data,boolean create_undo_ops,boolean erase_contents) throws org.jboss.cache.CacheException;

  java.lang.Object _put(org.jboss.cache.GlobalTransaction tx,java.lang.String fqn,java.lang.Object key,java.lang.Object value,boolean create_undo_ops) throws org.jboss.cache.CacheException;

  java.lang.Object _put(org.jboss.cache.GlobalTransaction tx,org.jboss.cache.Fqn fqn,java.lang.Object key,java.lang.Object value,boolean create_undo_ops) throws org.jboss.cache.CacheException;

  void _remove(org.jboss.cache.GlobalTransaction tx,java.lang.String fqn,boolean create_undo_ops) throws org.jboss.cache.CacheException;

  void _remove(org.jboss.cache.GlobalTransaction tx,org.jboss.cache.Fqn fqn,boolean create_undo_ops) throws org.jboss.cache.CacheException;

  java.lang.Object _remove(org.jboss.cache.GlobalTransaction tx,java.lang.String fqn,java.lang.Object key,boolean create_undo_ops) throws org.jboss.cache.CacheException;

  java.lang.Object _remove(org.jboss.cache.GlobalTransaction tx,org.jboss.cache.Fqn fqn,java.lang.Object key,boolean create_undo_ops) throws org.jboss.cache.CacheException;

}
