/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BusinessServiceHandler
extends AbstractHandler {
    public static final String TAG_NAME = "businessService";
    private HandlerMaker maker = null;

    protected BusinessServiceHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        int i;
        BusinessService obj = new BusinessService();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setBusinessKey(element.getAttribute("businessKey"));
        obj.setServiceKey(element.getAttribute("serviceKey"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("name");
            obj.addName((Name)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            obj.addDescription((Description)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "bindingTemplates");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("bindingTemplates");
            obj.setBindingTemplates((BindingTemplates)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "categoryBag")).size() > 0) {
            handler = this.maker.lookup("categoryBag");
            obj.setCategoryBag((CategoryBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        CategoryBag categoryBag;
        BindingTemplates bindings;
        Vector descrVector;
        Vector nameVector;
        BusinessService service = (BusinessService)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String serviceKey = service.getServiceKey();
        if (serviceKey != null) {
            element.setAttribute("serviceKey", serviceKey);
        } else {
            element.setAttribute("serviceKey", "");
        }
        String businessKey = service.getBusinessKey();
        if (businessKey != null) {
            element.setAttribute("businessKey", businessKey);
        }
        if ((nameVector = service.getNameVector()) != null && nameVector.size() > 0) {
            handler = this.maker.lookup("name");
            for (int i = 0; i < nameVector.size(); ++i) {
                handler.marshal((Name)nameVector.elementAt(i), element);
            }
        }
        if ((descrVector = service.getDescriptionVector()) != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        if ((bindings = service.getBindingTemplates()) != null) {
            handler = this.maker.lookup("bindingTemplates");
            handler.marshal(bindings, element);
        }
        if ((categoryBag = service.getCategoryBag()) != null && categoryBag.getKeyedReferenceVector() != null && !categoryBag.getKeyedReferenceVector().isEmpty()) {
            handler = this.maker.lookup("categoryBag");
            handler.marshal(categoryBag, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        OverviewDoc overDoc = new OverviewDoc();
        overDoc.setOverviewURL("http://www.sviens.com/service.html");
        overDoc.addDescription(new Description("over-doc Descr"));
        overDoc.addDescription(new Description("over-doc Descr Two", "en"));
        InstanceDetails instDetails = new InstanceDetails();
        instDetails.addDescription(new Description("body-isa-wunder"));
        instDetails.addDescription(new Description("sweetchild-o-mine", "it"));
        instDetails.setInstanceParms("inst-det parameters");
        instDetails.setOverviewDoc(overDoc);
        TModelInstanceInfo tModInstInfo = new TModelInstanceInfo();
        tModInstInfo.setTModelKey("uuid:ae0f9fd4-287f-40c9-be91-df47a7c72fd9");
        tModInstInfo.addDescription(new Description("tMod-Inst-Info"));
        tModInstInfo.addDescription(new Description("tMod-Inst-Info too", "es"));
        tModInstInfo.setInstanceDetails(instDetails);
        TModelInstanceDetails tModInstDet = new TModelInstanceDetails();
        tModInstDet.addTModelInstanceInfo(tModInstInfo);
        BindingTemplate binding = new BindingTemplate();
        binding.setBindingKey("c9613c3c-fe55-4f34-a3da-b3167afbca4a");
        binding.setServiceKey("997a55bc-563d-4c04-8a94-781604870d31");
        binding.addDescription(new Description("whatever"));
        binding.addDescription(new Description("whatever too", "fr"));
        binding.setHostingRedirector(new HostingRedirector("92658289-0bd7-443c-8948-0bb4460b44c0"));
        binding.setAccessPoint(new AccessPoint("http", "http://www.sviens.com/service.wsdl"));
        binding.setTModelInstanceDetails(tModInstDet);
        BindingTemplates bindings = new BindingTemplates();
        bindings.addBindingTemplate(binding);
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(new KeyedReference("keyName", "keyValue"));
        catBag.addKeyedReference(new KeyedReference("uuid:dfddb58c-4853-4a71-865c-f84509017cc7", "keyName2", "keyValue2"));
        BusinessService service = new BusinessService();
        service.setServiceKey("fe8af00d-3a2c-4e05-b7ca-95a1259aad4f");
        service.setBusinessKey("b8cc7266-9eed-4675-b621-34697f252a77");
        service.setBindingTemplates(bindings);
        service.setCategoryBag(catBag);
        service.addName(new Name("serviceNm"));
        service.addName(new Name("serviceNm2", "en"));
        service.addDescription(new Description("service whatever"));
        service.addDescription(new Description("service whatever too", "it"));
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

