/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.ContactTable;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class PhoneTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$PhoneTable == null ? (class$org$apache$juddi$datastore$jdbc$PhoneTable = PhoneTable.class$("org.apache.juddi.datastore.jdbc.PhoneTable")) : class$org$apache$juddi$datastore$jdbc$PhoneTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$PhoneTable;

    PhoneTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, Vector phoneList, Connection connection) throws SQLException {
        if (phoneList == null || phoneList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            int listSize = phoneList.size();
            for (int phoneID = 0; phoneID < listSize; ++phoneID) {
                Phone phone = (Phone)phoneList.elementAt(phoneID);
                statement.setInt(3, phoneID);
                statement.setString(4, phone.getUseType());
                statement.setString(5, phone.getValue());
                log.debug((Object)("insert into PHONE table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t PHONE_ID=" + phoneID + "\n\t USE_TYPE=" + phone.getUseType() + "\n\t PHONE_NUMBER=" + phone.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, Connection connection) throws SQLException {
        Vector<Phone> phoneList = new Vector<Phone>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            log.debug((Object)("select from PHONE table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Phone phone = new Phone();
                phone.setUseType(resultSet.getString(1));
                phone.setValue(resultSet.getString(2));
                phoneList.add(phone);
            }
            Vector<Phone> vector = phoneList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from the PHONE table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            PhoneTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                Vector<Contact> contactList = new Vector<Contact>();
                Contact contact = new Contact("John Smith");
                contact.setUseType("tech support");
                contactList.add(contact);
                int contactID = 0;
                Vector phoneList = new Vector();
                Phone phone = null;
                phone = new Phone("603.457.8110");
                phone.setUseType("Voice Mailbox");
                phoneList.add(phone);
                phone = new Phone("603.457.8111");
                phone.setUseType("Fax");
                phoneList.add(phone);
                phone = new Phone("603.457.8112");
                phone.setUseType("Mobil");
                phoneList.add(phone);
                phone = new Phone("603.457.8113");
                phone.setUseType("Pager");
                phoneList.add(phone);
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                ContactTable.insert(businessKey, contactList, connection);
                PhoneTable.insert(businessKey, contactID, phoneList, connection);
                phoneList = PhoneTable.select(businessKey, contactID, connection);
                PhoneTable.delete(businessKey, connection);
                phoneList = PhoneTable.select(businessKey, contactID, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO PHONE (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("PHONE_ID,");
        sql.append("USE_TYPE,");
        sql.append("PHONE_NUMBER) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("USE_TYPE,");
        sql.append("PHONE_NUMBER, ");
        sql.append("PHONE_ID ");
        sql.append("FROM PHONE ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("ORDER BY PHONE_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM PHONE ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

