/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BindingTemplateTable;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.BusinessServiceTable;
import org.apache.juddi.datastore.jdbc.TModelInstanceInfoTable;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class InstanceDetailsDescTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$InstanceDetailsDescTable == null ? (class$org$apache$juddi$datastore$jdbc$InstanceDetailsDescTable = InstanceDetailsDescTable.class$("org.apache.juddi.datastore.jdbc.InstanceDetailsDescTable")) : class$org$apache$juddi$datastore$jdbc$InstanceDetailsDescTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$InstanceDetailsDescTable;

    InstanceDetailsDescTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String bindingKey, int tModelInstanceInfoID, Vector descList, Connection connection) throws SQLException {
        if (descList == null || descList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, bindingKey.toString());
            statement.setInt(2, tModelInstanceInfoID);
            int listSize = descList.size();
            for (int descID = 0; descID < listSize; ++descID) {
                Description desc = (Description)descList.elementAt(descID);
                statement.setInt(3, descID);
                statement.setString(4, desc.getLanguageCode());
                statement.setString(5, desc.getValue());
                log.debug((Object)("insert into INSTANCE_DETAILS_DESCR table:\n\n\t" + insertSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n\t TMODEL_INSTANCE_INFO_ID=" + tModelInstanceInfoID + "\n\t INSTANCE_DETAILS_DESCR_ID=" + descID + "\n\t LANG_CODE=" + desc.getLanguageCode() + "\n\t DESCR=" + desc.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String bindingKey, int tModelInstanceInfoID, Connection connection) throws SQLException {
        Vector<Description> descList = new Vector<Description>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, bindingKey.toString());
            statement.setInt(2, tModelInstanceInfoID);
            log.debug((Object)("select from INSTANCE_DETAILS_DESCR table:\n\n\t" + selectSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n\t TMODEL_INSTANCE_INFO_ID=" + tModelInstanceInfoID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Description desc = new Description();
                desc.setLanguageCode(resultSet.getString(1));
                desc.setValue(resultSet.getString(2));
                descList.add(desc);
                desc = null;
            }
            Vector<Description> vector = descList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String bindingKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, bindingKey.toString());
            log.debug((Object)("delete from INSTANCE_DETAILS_DESCR table:\n\n\t" + deleteSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            InstanceDetailsDescTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                String serviceKey = uuidgen.uuidgen();
                BusinessService service = new BusinessService();
                service.setBusinessKey(businessKey);
                service.setServiceKey(serviceKey);
                String bindingKey = uuidgen.uuidgen();
                BindingTemplate binding = new BindingTemplate();
                binding.setServiceKey(serviceKey);
                binding.setBindingKey(bindingKey);
                binding.setAccessPoint(new AccessPoint("http://www.juddi.org/bindingtemplate.html", "http"));
                Vector<TModelInstanceInfo> infoList = new Vector<TModelInstanceInfo>();
                infoList.add(new TModelInstanceInfo(uuidgen.uuidgen()));
                int infoID = 0;
                Vector descList = new Vector();
                descList.add(new Description("blah, blah, blah", "en"));
                descList.add(new Description("Yadda, Yadda, Yadda", "it"));
                descList.add(new Description("WhoobWhoobWhoobWhoob", "cy"));
                descList.add(new Description("Haachachachacha", "km"));
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                BusinessServiceTable.insert(service, connection);
                BindingTemplateTable.insert(binding, connection);
                TModelInstanceInfoTable.insert(bindingKey, infoList, connection);
                InstanceDetailsDescTable.insert(bindingKey, infoID, descList, connection);
                descList = InstanceDetailsDescTable.select(bindingKey, infoID, connection);
                InstanceDetailsDescTable.delete(bindingKey, connection);
                descList = InstanceDetailsDescTable.select(bindingKey, infoID, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO INSTANCE_DETAILS_DESCR (");
        sql.append("BINDING_KEY,");
        sql.append("TMODEL_INSTANCE_INFO_ID,");
        sql.append("INSTANCE_DETAILS_DESCR_ID,");
        sql.append("LANG_CODE,");
        sql.append("DESCR) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LANG_CODE,");
        sql.append("DESCR, ");
        sql.append("INSTANCE_DETAILS_DESCR_ID ");
        sql.append("FROM INSTANCE_DETAILS_DESCR ");
        sql.append("WHERE BINDING_KEY=? ");
        sql.append("AND TMODEL_INSTANCE_INFO_ID=? ");
        sql.append("ORDER BY INSTANCE_DETAILS_DESCR_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM INSTANCE_DETAILS_DESCR ");
        sql.append("WHERE BINDING_KEY=?");
        deleteSQL = sql.toString();
    }
}

