/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.DynamicQuery;
import org.apache.juddi.util.jdbc.Transaction;

class FindBusinessByCategoryQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindBusinessByCategoryQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindBusinessByCategoryQuery = FindBusinessByCategoryQuery.class$("org.apache.juddi.datastore.jdbc.FindBusinessByCategoryQuery")) : class$org$apache$juddi$datastore$jdbc$FindBusinessByCategoryQuery));
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindBusinessByCategoryQuery;

    FindBusinessByCategoryQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(CategoryBag categoryBag, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBusinessByCategoryQuery.appendWhere(sql, categoryBag, qualifiers);
        FindBusinessByCategoryQuery.appendIn(sql, keysIn);
        FindBusinessByCategoryQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            vector = keysOut;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, CategoryBag categoryBag, FindQualifiers qualifiers) {
        int vectorSize;
        Vector keyedRefVector;
        sql.append("WHERE B.BUSINESS_KEY = C.BUSINESS_KEY ");
        if (categoryBag != null && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null && (vectorSize = keyedRefVector.size()) > 0) {
            sql.append("AND (");
            for (int i = 0; i < vectorSize; ++i) {
                KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                String key = keyedRef.getTModelKey();
                String name = keyedRef.getKeyName();
                String value = keyedRef.getKeyValue();
                if (name == null) {
                    name = "";
                }
                if (value == null) {
                    value = "";
                }
                if (key.equals("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4")) {
                    sql.append("(C.TMODEL_KEY_REF = ? AND C.KEY_NAME = ? AND C.KEY_VALUE = ?)");
                    sql.addValue(key);
                    sql.addValue(name);
                    sql.addValue(value);
                    if (i + 1 >= vectorSize) continue;
                    sql.append(" OR ");
                    continue;
                }
                sql.append("(C.TMODEL_KEY_REF = ? AND C.KEY_VALUE = ?)");
                sql.addValue(key);
                sql.addValue(value);
                if (i + 1 >= vectorSize) continue;
                sql.append(" OR ");
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BUSINESS_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("B.LAST_UPDATE ASC");
        } else {
            sql.append("B.LAST_UPDATE DESC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            FindBusinessByCategoryQuery.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        CategoryBag categoryBag = new CategoryBag();
        Vector<KeyedReference> keyedRefVector = new Vector<KeyedReference>();
        keyedRefVector.addElement(new KeyedReference("uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4", "ntis-gov:NAICS:1997", "51121"));
        keyedRefVector.addElement(new KeyedReference("uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4", "Mining", "21"));
        keyedRefVector.addElement(new KeyedReference("uuid:DB77450D-9FA8-45D4-A7BC-04411D14E384", null, "abcdefg"));
        keyedRefVector.addElement(new KeyedReference("uuid:DB77450D-9FA8-45D4-A7BC-04411D14E384", "1775f0f8-cd47-451d-88da-73ce508836f3", "blah, blah, blah"));
        categoryBag.setKeyedReferenceVector(keyedRefVector);
        Vector<String> keysIn = new Vector<String>();
        keysIn.add("740d75b1-3cde-4547-85dd-9578cd3ea1cd");
        keysIn.add("c311085b-3277-470d-8ce9-07b81c484e4b");
        keysIn.add("6b368a5a-6a62-4f23-a002-f11e22780a91");
        keysIn.add("45994713-d3c3-40d6-87b5-6ce51f36001c");
        keysIn.add("901b15c5-799c-4387-8337-a1a35fceb791");
        keysIn.add("80fdae14-0e5d-4ea6-8eb8-50fde422056d");
        keysIn.add("e1996c33-c436-4004-9e3e-14de191bcc6b");
        keysIn.add("3ef4772f-e04b-46ed-8065-c5a4e167b5ba");
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                FindBusinessByCategoryQuery.select(categoryBag, keysIn, null, connection);
                FindBusinessByCategoryQuery.select(categoryBag, null, null, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BUSINESS_KEY,B.LAST_UPDATE ");
        sql.append("FROM BUSINESS_ENTITY B,BUSINESS_CATEGORY C ");
        selectSQL = sql.toString();
    }
}

