/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Modification;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.blocks.MethodCall;

public class CacheStoreInterceptor
extends Interceptor {
    private CacheLoader loader = null;
    private TransactionManager tx_mgr = null;
    private TransactionTable tx_table = null;
    private List transactions = Collections.synchronizedList(new ArrayList());
    final ReentrantLock lock = new ReentrantLock();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Object key;
        Fqn fqn;
        Transaction tx;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object retval = null;
        Object tmp_retval = null;
        boolean use_tmp_retval = false;
        if (this.tx_mgr != null && (tx = this.tx_mgr.getTransaction()) != null && this.isValid(tx)) {
            this.lock.acquire();
            try {
                if (!this.transactions.contains(tx)) {
                    this.transactions.add(tx);
                    GlobalTransaction gtx = this.cache.getCurrentTransaction(tx);
                    if (gtx == null) {
                        throw new Exception("failed to get global transaction");
                    }
                    tx.registerSynchronization((Synchronization)new SynchronizationHandler(gtx, tx, this.cache));
                }
                this.lock.release();
                Object object = super.invoke(m);
                return object;
            }
            finally {
                if (this.lock.holds() > 0L) {
                    this.lock.release();
                }
            }
        }
        CacheStoreInterceptor cacheStoreInterceptor = this;
        synchronized (cacheStoreInterceptor) {
            if (meth.equals(TreeCache.removeNodeMethodLocal)) {
                fqn = (Fqn)args[1];
                this.loader.remove(fqn);
            } else if (meth.equals(TreeCache.removeKeyMethodLocal)) {
                fqn = (Fqn)args[1];
                key = args[2];
                tmp_retval = this.loader.remove(fqn, key);
                use_tmp_retval = true;
            } else if (meth.equals(TreeCache.removeDataMethodLocal)) {
                fqn = (Fqn)args[1];
                this.loader.removeData(fqn);
            }
        }
        retval = super.invoke(m);
        cacheStoreInterceptor = this;
        synchronized (cacheStoreInterceptor) {
            if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal)) {
                fqn = (Fqn)args[1];
                Map attributes = (Map)args[2];
                this.loader.put(fqn, attributes);
            } else if (meth.equals(TreeCache.putKeyValMethodLocal)) {
                fqn = (Fqn)args[1];
                key = args[2];
                Object value = args[3];
                this.loader.put(fqn, key, value);
            }
        }
        if (use_tmp_retval) {
            return tmp_retval;
        }
        return retval;
    }

    private CacheLoader getLoader() {
        return this.loader != null ? this.loader : (this.loader = this.cache.getCacheLoader());
    }

    private void prepareCacheLoader(GlobalTransaction gtx) throws Exception {
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List modifications = entry.getModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        Iterator it = modifications.iterator();
        while (it.hasNext()) {
            MethodCall methodCall = (MethodCall)it.next();
            Modification mod = this.convertMethodCallToModification(methodCall);
            cache_loader_modifications.add(mod);
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, false);
        }
    }

    private Modification convertMethodCallToModification(MethodCall methodCall) throws Exception {
        Method method = methodCall.getMethod();
        if (method == null) {
            throw new Exception("method call has no method: " + methodCall);
        }
        Object[] args = methodCall.getArgs();
        if (TreeCache.putDataMethodLocal.equals(method)) {
            return new Modification(2, (Fqn)args[1], (Map)args[2]);
        }
        if (TreeCache.putDataEraseMethodLocal.equals(method)) {
            return new Modification(3, (Fqn)args[1], (Map)args[2]);
        }
        if (TreeCache.putKeyValMethodLocal.equals(method)) {
            return new Modification(1, (Fqn)args[1], args[2], args[3]);
        }
        if (TreeCache.removeNodeMethodLocal.equals(method)) {
            return new Modification(4, (Fqn)args[1]);
        }
        if (TreeCache.removeKeyMethodLocal.equals(method)) {
            return new Modification(5, (Fqn)args[1], args[2]);
        }
        if (TreeCache.removeDataMethodLocal.equals(method)) {
            return new Modification(6, (Fqn)args[1]);
        }
        throw new Exception("method call " + method.getName() + " cannot be converted to a modification");
    }

    class SynchronizationHandler
    implements Synchronization {
        GlobalTransaction gtx = null;
        Transaction tx = null;
        TreeCache cache = null;
        List modifications;

        SynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
            TransactionEntry entry = CacheStoreInterceptor.this.tx_table.get(gtx);
            if (entry != null) {
                this.modifications = entry.getModifications();
            }
        }

        public void beforeCompletion() {
            try {
                int status = this.tx.getStatus();
                switch (status) {
                    case 0: 
                    case 7: 
                    case 8: {
                        CacheStoreInterceptor.this.prepareCacheLoader(this.gtx);
                        break;
                    }
                    case 1: 
                    case 9: {
                        break;
                    }
                    default: {
                        CacheStoreInterceptor.this.log.error((Object)("beforeCompletion(). Illegal tx status: " + status));
                        throw new IllegalStateException("Illegal status: " + status);
                    }
                }
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("", t);
            }
        }

        public void afterCompletion(int status) {
            CacheStoreInterceptor.this.transactions.remove(this.tx);
            switch (status) {
                case 3: {
                    try {
                        if (this.modifications == null || this.modifications.size() == 0) {
                            return;
                        }
                        CacheStoreInterceptor.this.getLoader().commit(this.gtx);
                    }
                    catch (Exception e) {
                        CacheStoreInterceptor.this.log.error((Object)"failed committing transaction to cache loader", (Throwable)e);
                    }
                    break;
                }
                case 1: 
                case 4: {
                    CacheStoreInterceptor.this.getLoader().rollback(this.gtx);
                }
            }
        }
    }
}

