/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.entity;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.emb.ContentAccessException;
import javax.emb.MediaEntityLocal;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MetaDataEntityLocal;
import javax.emb.MetaDataSyntaxException;
import javax.emb.UnsupportedQueryLanguageException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
import org.jboss.ejb.plugins.keygenerator.KeyGeneratorFactory;
import org.jboss.logging.Logger;
import org.jboss.media.entity.query.JBossMediaQueryLanguage;
import org.jboss.media.entity.query.MediaQueryLanguage;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class MetaDataEntityBean
implements EntityBean {
    private EntityContext entityContext;
    private Logger log = Logger.getLogger((Class)(class$org$jboss$media$entity$MetaDataEntityBean == null ? (class$org$jboss$media$entity$MetaDataEntityBean = MetaDataEntityBean.class$("org.jboss.media.entity.MetaDataEntityBean")) : class$org$jboss$media$entity$MetaDataEntityBean));
    private static final String KEY_GENERATOR_JNDI = "UUIDKeyGeneratorFactory";
    private static final MediaQueryLanguage[] MEDIA_QUERY_LANGUAGES = new MediaQueryLanguage[]{new JBossMediaQueryLanguage()};
    static /* synthetic */ Class class$org$jboss$media$entity$MetaDataEntityBean;

    public abstract String getManagedIdentity();

    public abstract void setManagedIdentity(String var1);

    public abstract String getManagedXML();

    public abstract void setManagedXML(String var1);

    public abstract String getManagedName();

    public abstract void setManagedName(String var1);

    public abstract long getManagedLastModified();

    public abstract void setManagedLastModified(long var1);

    public abstract MetaDataEntityLocal getManagedPreviousVersion();

    public abstract void setManagedPreviousVersion(MetaDataEntityLocal var1);

    public abstract MetaDataEntityLocal getManagedNextVersion();

    public abstract void setManagedNextVersion(MetaDataEntityLocal var1);

    public abstract Collection getManagedParents();

    public abstract void setManagedParents(Collection var1);

    public abstract Collection getManagedChildren();

    public abstract void setManagedChildren(Collection var1);

    public abstract Collection getManagedMedias();

    public abstract void setManagedMedias(Collection var1);

    public void addChild(MetaDataEntityLocal child) throws MediaException {
        if (child == null) {
            throw new NullPointerException();
        }
        if (!this.getManagedChildren().contains(child)) {
            this.getManagedChildren().add(child);
        }
    }

    public void addMediaEntity(MediaEntityLocal mediaEntity) throws MediaException {
        if (mediaEntity == null) {
            throw new NullPointerException();
        }
        if (!this.getManagedMedias().contains(mediaEntity)) {
            this.getManagedMedias().add(mediaEntity);
            this.updateLastModified();
        }
    }

    public MetaDataEntityLocal[] getChildren() throws MediaException {
        return this.getManagedChildren().toArray(new MetaDataEntityLocal[0]);
    }

    public long getLastModified() throws MediaException {
        return this.getManagedLastModified();
    }

    public MediaEntityLocal[] getMediaEntities() throws MediaException {
        return this.getManagedMedias().toArray(new MediaEntityLocal[0]);
    }

    public MediaEntityLocal[] getMediaEntities(MediaFormat mediaFormat, boolean searchChildren) throws MediaException {
        if (mediaFormat == null) {
            throw new NullPointerException();
        }
        ArrayList<MediaEntityLocal> mediaEntities = new ArrayList<MediaEntityLocal>();
        Iterator it = this.getManagedMedias().iterator();
        while (it.hasNext()) {
            MediaEntityLocal mediaEntity = (MediaEntityLocal)it.next();
            MediaFormat format = mediaEntity.getFormat();
            if (mediaFormat != format) continue;
            mediaEntities.add(mediaEntity);
        }
        if (searchChildren) {
            MetaDataEntityLocal[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                MediaEntityLocal[] mediaEntity = children[i].getMediaEntities(mediaFormat, searchChildren);
                for (int j = 0; j < mediaEntity.length; ++j) {
                    mediaEntities.add(mediaEntity[j]);
                }
            }
        }
        return mediaEntities.toArray(new MediaEntityLocal[0]);
    }

    public MediaEntityLocal[] getMediaEntities(String mimeType, boolean searchChildren) throws MediaException {
        if (mimeType == null) {
            throw new NullPointerException();
        }
        ArrayList<MediaEntityLocal> mediaEntities = new ArrayList<MediaEntityLocal>();
        Iterator it = this.getManagedMedias().iterator();
        while (it.hasNext()) {
            MediaEntityLocal mediaEntity = (MediaEntityLocal)it.next();
            String type = mediaEntity.getMimeType();
            if (!mimeType.equals(type)) continue;
            mediaEntities.add(mediaEntity);
        }
        if (searchChildren) {
            MetaDataEntityLocal[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                MediaEntityLocal[] mediaEntity = children[i].getMediaEntities(mimeType, searchChildren);
                for (int j = 0; j < mediaEntity.length; ++j) {
                    mediaEntities.add(mediaEntity[j]);
                }
            }
        }
        return mediaEntities.toArray(new MediaEntityLocal[0]);
    }

    public String getName() throws MediaException {
        return this.getManagedName();
    }

    public MetaDataEntityLocal getNextVersion() throws MediaException {
        return this.getManagedNextVersion();
    }

    public MetaDataEntityLocal[] getParents() throws MediaException {
        return this.getManagedParents().toArray(new MetaDataEntityLocal[0]);
    }

    public MetaDataEntityLocal getPreviousVersion() throws MediaException {
        return this.getManagedPreviousVersion();
    }

    public String getXML() throws MediaException {
        String xml = this.getManagedXML();
        if (xml == null) {
            throw new ContentAccessException();
        }
        return xml;
    }

    public void removeChild(MetaDataEntityLocal child) throws MediaException {
        if (child == null) {
            throw new NullPointerException();
        }
        if (this.getManagedChildren().contains(child)) {
            this.getManagedChildren().remove(child);
        }
    }

    public void removeMediaEntity(MediaEntityLocal mediaEntity) throws MediaException {
        if (mediaEntity == null) {
            throw new NullPointerException();
        }
        if (this.getManagedMedias().contains(mediaEntity)) {
            this.getManagedMedias().remove(mediaEntity);
        }
    }

    public void setName(String name) throws MediaException {
        if (name == null) {
            throw new NullPointerException();
        }
        this.setManagedName(name);
        this.updateLastModified();
    }

    public void setPreviousVersion(MetaDataEntityLocal metadata) throws MediaException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void setXML(String xmlContent, boolean validate) throws MediaException {
        if (xmlContent == null) {
            throw new NullPointerException();
        }
        if (validate) {
            StringReader xmlReader = new StringReader(xmlContent);
            try {
                InputSource xmlSource = new InputSource(xmlReader);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(xmlSource);
            }
            catch (Exception e) {
                throw new MetaDataSyntaxException((Throwable)e);
            }
        }
        this.setManagedXML(xmlContent);
        this.updateLastModified();
    }

    public String ejbCreate() throws CreateException {
        String identity = this.generateIdentity();
        this.setManagedIdentity(identity);
        this.updateLastModified();
        return null;
    }

    public void ejbPostCreate() throws CreateException {
    }

    public Collection ejbHomeQuery(String query, String queryLanguage, Map options) throws FinderException, MediaException {
        if (query == null || queryLanguage == null) {
            throw new NullPointerException();
        }
        MediaQueryLanguage mediaQueryLanguage = null;
        for (int i = 0; i < MEDIA_QUERY_LANGUAGES.length; ++i) {
            if (!queryLanguage.equals(MEDIA_QUERY_LANGUAGES[i].getName())) continue;
            mediaQueryLanguage = MEDIA_QUERY_LANGUAGES[i];
        }
        if (mediaQueryLanguage == null) {
            throw new UnsupportedQueryLanguageException();
        }
        mediaQueryLanguage.setOptions(options);
        return mediaQueryLanguage.query(this, query);
    }

    public String[] ejbHomeRetrieveSupportedOptions(String queryLanguage) throws MediaException {
        if (queryLanguage == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < MEDIA_QUERY_LANGUAGES.length; ++i) {
            MediaQueryLanguage mediaQueryLanguage = MEDIA_QUERY_LANGUAGES[i];
            if (!queryLanguage.equals(mediaQueryLanguage.getName())) continue;
            Map options = mediaQueryLanguage.getOptions();
            String[] supportedOptions = new String[options.size()];
            Iterator it = options.keySet().iterator();
            int j = 0;
            while (it.hasNext()) {
                String option;
                supportedOptions[j] = option = (String)it.next();
                ++j;
            }
            return supportedOptions;
        }
        throw new UnsupportedQueryLanguageException();
    }

    public String[] ejbHomeRetrieveSupportedQueryLanguages() throws MediaException {
        String[] supportedQueryLanguages = new String[MEDIA_QUERY_LANGUAGES.length];
        for (int i = 0; i < MEDIA_QUERY_LANGUAGES.length; ++i) {
            supportedQueryLanguages[i] = MEDIA_QUERY_LANGUAGES[i].getName();
        }
        return supportedQueryLanguages;
    }

    public abstract Collection ejbSelectByPartialXML(String var1) throws FinderException;

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() throws RemoveException {
    }

    public void setEntityContext(EntityContext entityContext) {
        this.entityContext = entityContext;
    }

    public void unsetEntityContext() {
        this.entityContext = null;
    }

    public void ejbLoad() {
    }

    public void ejbStore() {
    }

    private void updateLastModified() {
        this.setManagedLastModified(System.currentTimeMillis());
    }

    private String generateIdentity() throws CreateException {
        KeyGenerator keyGenerator = null;
        try {
            KeyGeneratorFactory keyGeneratorFactory = (KeyGeneratorFactory)new InitialContext().lookup(KEY_GENERATOR_JNDI);
            keyGenerator = keyGeneratorFactory.getKeyGenerator();
        }
        catch (NamingException e) {
            throw new CreateException("Error: can't find key generator factory: UUIDKeyGeneratorFactory; " + e.getMessage());
        }
        catch (Exception e) {
            throw new CreateException("Error: can't create key generator instance; key generator factory: UUIDKeyGeneratorFactory; " + e.getMessage());
        }
        return (String)keyGenerator.generateKey();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

