/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegistryServlet
extends HttpServlet {
    private static final String CONFIG_FILE_PROPERTY_NAME = "juddi.propertiesFile";
    private static final String DEFAULT_PROPERTY_FILE = "/WEB-INF/juddi.properties";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$registry$RegistryServlet == null ? (class$org$apache$juddi$registry$RegistryServlet = RegistryServlet.class$("org.apache.juddi.registry.RegistryServlet")) : class$org$apache$juddi$registry$RegistryServlet));
    private static HandlerMaker maker = HandlerMaker.getInstance();
    private static DocumentBuilder docBuilder = null;
    private static RegistryEngine registry = null;
    static /* synthetic */ Class class$org$apache$juddi$registry$RegistryServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Properties props = new Properties();
        try {
            InputStream is;
            log.info((Object)"Loading jUDDI configuration.");
            String propFile = config.getInitParameter(CONFIG_FILE_PROPERTY_NAME);
            if (propFile == null || propFile.trim().length() == 0) {
                propFile = DEFAULT_PROPERTY_FILE;
            }
            if ((is = this.getServletContext().getResourceAsStream(propFile)) != null) {
                log.info((Object)("Resources loaded from: " + propFile));
                props.load(is);
            } else {
                log.warn((Object)("Could not locate jUDDI properties '" + propFile + "'. Using defaults."));
                props.put("juddi.operatorName", "Apache.org");
                props.put("juddi.operatorURL", "http://localhost:8080/juddi/");
                props.put("juddi.adminEmailAddress", "nobody@apache.org");
                props.put("juddi.dataSource", "java:comp/env/jdbc/juddiDB");
                props.put("juddi.auth", "org.apache.juddi.auth.DefaultAuthenticator");
                props.put("juddi.cryptor", "org.apache.juddi.cryptor.DefaultCryptor");
                props.put("juddi.dataStore", "org.apache.juddi.datastore.JDBCDataStore");
                props.put("juddi.monitor", "org.apache.juddi.monitor.jdbc.JDBCMonitor");
                props.put("juddi.uuidgen", "org.apache.juddi.uuidgen.DefaultUUIDGen");
                props.put("juddi.validator", "org.apache.juddi.validator.DefaultValidator");
                props.put("juddi.maxNameElementsAllowed", Integer.toString(5));
                props.put("juddi.maxNameLengthAllowed", Integer.toString(255));
                props.put("juddi.maxMessageSize", Integer.toString(0x200000));
                props.put("juddi.maxBusinessEntitiesPerUser", Integer.toString(25));
                props.put("juddi.maxBusinessServicesPerBusiness", Integer.toString(20));
                props.put("juddi.maxBindingTemplatesPerService", Integer.toString(10));
                props.put("juddi.maxTModelsPerUser", Integer.toString(100));
                props.put("juddi.maxRowsLimit", Integer.toString(10));
            }
        }
        catch (IOException ioex) {
            log.error((Object)ioex.getMessage(), (Throwable)ioex);
        }
        log.info((Object)"Initializing jUDDI components.");
        registry = new RegistryEngine(props);
        registry.init();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setHeader("Allow", "POST");
        res.sendError(405, "The request method 'GET' is not allowed by the UDDI Inquiry API.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block23: {
            res.setContentType("text/xml; charset=utf-8");
            SOAPMessage soapReq = null;
            SOAPMessage soapRes = null;
            MessageFactory msgFactory = MessageFactory.newInstance();
            soapReq = msgFactory.createMessage(null, (InputStream)req.getInputStream());
            soapRes = msgFactory.createMessage();
            SOAPBody soapReqBody = soapReq.getSOAPBody();
            Element uddiReq = (Element)soapReqBody.getFirstChild();
            if (uddiReq == null) {
                throw new FatalErrorException("A UDDI request was not found in the SOAP message.");
            }
            String function = uddiReq.getLocalName();
            if (function == null || function.trim().length() == 0) {
                throw new FatalErrorException("The name of the UDDI request could not be identified.");
            }
            AbstractHandler requestHandler = maker.lookup(function);
            if (requestHandler == null) {
                throw new UnsupportedException("The UDDI request type specified is unknown: " + function);
            }
            String generic = uddiReq.getAttribute("generic");
            if (generic == null) {
                throw new FatalErrorException("A UDDI generic attribute value was not found for UDDI request: " + function + " (The " + "'generic' attribute must be present)");
            }
            if (!generic.equals("2.0")) {
                throw new UnsupportedException("Currently only UDDI v2 requests are supported. The generic attribute value received was: " + generic);
            }
            RegistryObject uddiReqObj = requestHandler.unmarshal(uddiReq);
            RegistryObject uddiResObj = null;
            RegistryEngine registry = RegistryServlet.getRegistry();
            if (registry == null || !registry.isAvailable()) {
                throw new BusyException("The Registry is currently unavailable.");
            }
            uddiResObj = registry.execute(uddiReqObj);
            AbstractHandler responseHandler = maker.lookup(uddiResObj.getClass().getName());
            if (responseHandler == null) {
                throw new FatalErrorException("The response object type is unknown: " + uddiResObj.getClass().getName());
            }
            DocumentBuilder docBuilder = this.getDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element element = document.createElement("temp");
            responseHandler.marshal(uddiResObj, element);
            log.debug((Object)XMLUtils.toString((Element)element.getFirstChild()));
            document.appendChild(element.getFirstChild());
            soapRes.getSOAPBody().addDocument(document);
            Object var19_32 = null;
            try {
                soapRes.writeTo((OutputStream)res.getOutputStream());
            }
            catch (SOAPException sex) {
                log.error((Object)sex);
            }
            break block23;
            {
                catch (Exception ex) {
                    String faultCode = null;
                    String faultString = null;
                    String faultActor = null;
                    String errno = null;
                    String errCode = null;
                    String errMsg = null;
                    if (ex instanceof RegistryException) {
                        log.error((Object)ex.getMessage());
                        RegistryException rex = (RegistryException)ex;
                        faultCode = rex.getFaultCode();
                        faultString = rex.getFaultString();
                        faultActor = rex.getFaultActor();
                        DispositionReport dispRpt = rex.getDispositionReport();
                        if (dispRpt != null) {
                            Result result = null;
                            ErrInfo errInfo = null;
                            Vector results = dispRpt.getResultVector();
                            if (results != null && !results.isEmpty()) {
                                result = (Result)results.elementAt(0);
                            }
                            if (result != null) {
                                errno = String.valueOf(result.getErrno());
                                errInfo = result.getErrInfo();
                                if (errInfo != null) {
                                    errCode = errInfo.getErrCode();
                                    errMsg = errInfo.getErrMsg();
                                }
                            }
                        }
                    } else {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                        faultCode = "Server";
                        faultString = ex.getMessage();
                        faultActor = null;
                        errno = String.valueOf(10500);
                        errCode = "E_fatalError";
                        errMsg = "An internal UDDI server error has occurred. Please report this error to the UDDI server administrator.";
                    }
                    try {
                        SOAPBody soapResBody = soapRes.getSOAPBody();
                        SOAPFault soapFault = soapResBody.addFault();
                        soapFault.setFaultCode(faultCode);
                        soapFault.setFaultString(faultString);
                        soapFault.setFaultActor(faultActor);
                        Detail faultDetail = soapFault.addDetail();
                        SOAPElement dispRpt = faultDetail.addChildElement("dispositionReport", "", "urn:uddi-org:api_v2");
                        dispRpt.setAttribute("generic", "2.0");
                        dispRpt.setAttribute("operator", Config.getOperator());
                        SOAPElement result = dispRpt.addChildElement("result");
                        result.setAttribute("errno", errno);
                        SOAPElement errInfo = result.addChildElement("errInfo");
                        errInfo.setAttribute("errCode", errCode);
                        errInfo.setValue(errMsg);
                    }
                    catch (Exception e) {
                        log.error((Object)"A serious error has occured while assembling the SOAP Fault.", (Throwable)e);
                    }
                    Object var19_33 = null;
                    try {
                        soapRes.writeTo((OutputStream)res.getOutputStream());
                    }
                    catch (SOAPException sex) {
                        log.error((Object)sex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_34 = null;
                try {
                    soapRes.writeTo((OutputStream)res.getOutputStream());
                }
                catch (SOAPException sex) {
                    log.error((Object)sex);
                }
                throw throwable;
            }
        }
    }

    public void destroy() {
        super.destroy();
        log.info((Object)"jUDDI Stopping: Cleaning up existing resources.");
        RegistryEngine registry = RegistryServlet.getRegistry();
        if (registry != null) {
            registry.dispose();
        }
    }

    public static RegistryEngine getRegistry() {
        return registry;
    }

    private DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            docBuilder = this.createDocumentBuilder();
        }
        return docBuilder;
    }

    private synchronized DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

