/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindPublisher;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.PublisherInfo;
import org.apache.juddi.datatype.response.PublisherInfos;
import org.apache.juddi.datatype.response.PublisherList;
import org.apache.juddi.error.NameTooLongException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class FindPublisherFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$FindPublisherFunction == null ? (class$org$apache$juddi$function$FindPublisherFunction = FindPublisherFunction.class$("org.apache.juddi.function.FindPublisherFunction")) : class$org$apache$juddi$function$FindPublisherFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$FindPublisherFunction;

    public FindPublisherFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        FindPublisher request = (FindPublisher)regObject;
        String generic = request.getGeneric();
        String name = request.getNameString();
        FindQualifiers qualifiers = request.getFindQualifiers();
        int maxRows = request.getMaxRows();
        if (name == null || name.length() == 0) {
            PublisherList list = new PublisherList();
            list.setGeneric(generic);
            list.setPublisherInfos(new PublisherInfos());
            list.setOperator(Config.getOperator());
            list.setTruncated(false);
            return list;
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            Vector qVector;
            dataStore.beginTrans();
            if (name != null) {
                int maxNameLength = Config.getMaxNameLengthAllowed();
                if (name.length() > maxNameLength) {
                    throw new NameTooLongException("Name: '" + name + "' (max=" + maxNameLength + ")");
                }
            }
            if (qualifiers != null && (qVector = qualifiers.getFindQualifierVector()) != null && qVector.size() > 0) {
                for (int i = 0; i < qVector.size(); ++i) {
                    FindQualifier qualifier = (FindQualifier)qVector.elementAt(i);
                    String qValue = qualifier.getValue();
                    if (qValue.equals("exactNameMatch") || qValue.equals("caseSensitiveMatch") || qValue.equals("orAllKeys") || qValue.equals("orLikeKeys") || qValue.equals("andAllKeys") || qValue.equals("sortByNameAsc") || qValue.equals("sortByNameDesc") || qValue.equals("sortByDateAsc") || qValue.equals("sortByDateDesc") || qValue.equals("serviceSubset") || qValue.equals("combineCategoryBags")) continue;
                    throw new UnsupportedException("FindQualifier: " + qValue);
                }
            }
            Vector<PublisherInfo> infoVector = null;
            boolean truncatedResults = false;
            Vector idVector = dataStore.findPublisher(name, qualifiers);
            if (idVector != null && idVector.size() > 0) {
                int rowCount = idVector.size();
                if (maxRows > 0 && maxRows < rowCount) {
                    rowCount = maxRows;
                    truncatedResults = true;
                }
                infoVector = new Vector<PublisherInfo>(rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    infoVector.addElement(dataStore.fetchPublisherInfo((String)idVector.elementAt(i)));
                }
            }
            dataStore.commit();
            PublisherInfos infos = new PublisherInfos();
            infos.setPublisherInfoVector(infoVector);
            PublisherList list = new PublisherList();
            list.setGeneric(generic);
            list.setPublisherInfos(infos);
            list.setOperator(Config.getOperator());
            list.setTruncated(truncatedResults);
            PublisherList publisherList = list;
            return publisherList;
        }
        catch (NameTooLongException ntlex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ntlex.getMessage());
            throw ntlex;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)suppex.getMessage());
            throw suppex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

