/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.entity;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.entity.ValueObjectSubTask;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.XClass;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class ValueObjectTagsHandler
extends EjbTagsHandler {
    private XTag currentTag;
    private String currentValueObjectClass;
    private String currentValueObjectAttribute;
    private String currentValueObjectMatch;
    private String currentAggregateType;
    private String currentAggregateName;
    private String currentRelationBeanClass;
    static /* synthetic */ Class class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler;
    static /* synthetic */ Class class$xdoclet$modules$ejb$entity$ValueObjectSubTask;

    public static boolean isValueObjectRelation(XMethod method, String valueObject) {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler == null ? (class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectTagsHandler")) : class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler), (String)"isValueObjectRelation");
        boolean ret = method.getDoc().hasTag("ejb:value-object");
        if (log.isDebugEnabled()) {
            log.debug((Object)(method.getName() + " has a ejb:value-object Tag " + ret));
        }
        if (ret) {
            List tags = method.getDoc().getTags("ejb:value-object");
            if (tags.size() == 0 && !"*".equals(valueObject)) {
                ret = false;
            } else {
                ret = false;
                boolean excluded = true;
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    XTag tag = (XTag)i.next();
                    String exclude = tag.getAttributeValue("exclude");
                    String aggreg = tag.getAttributeValue("aggregate");
                    String comp = tag.getAttributeValue("compose");
                    if ("true".equals(exclude) || aggreg == null && comp == null) {
                        excluded = true;
                        ret = false;
                        break;
                    }
                    String value = tag.getAttributeValue("match");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method.getName() + " Match=" + value + "==" + valueObject));
                    }
                    if (value == null) {
                        if ("*".equals(valueObject)) {
                            ret = true;
                            break;
                        }
                        ret = false;
                        break;
                    }
                    if (!value.equals(valueObject) && !value.equals("*") && !"*".equals(valueObject)) continue;
                    ret = true;
                    break;
                }
                if ("*".equals(valueObject) && !excluded) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static boolean isGenerationNeeded(XClass clazz) {
        return true;
    }

    public static String getCurrentValueObjectClass(XClass clazz, XTag tag) throws XDocletException {
        String name = ValueObjectTagsHandler.getCurrentValueObjectName(tag);
        String _currentValueObjectClass = MessageFormat.format(ValueObjectTagsHandler.getSubTask().getValueObjectClassPattern(), name != null ? name : ValueObjectTagsHandler.getShortEjbNameFor(clazz));
        String packageName = clazz.getContainingPackage().getName();
        packageName = ValueObjectTagsHandler.choosePackage(packageName, null, DocletTask.getSubTaskName((Class)(class$xdoclet$modules$ejb$entity$ValueObjectSubTask == null ? (class$xdoclet$modules$ejb$entity$ValueObjectSubTask = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectSubTask")) : class$xdoclet$modules$ejb$entity$ValueObjectSubTask)));
        _currentValueObjectClass = packageName + '.' + _currentValueObjectClass;
        return _currentValueObjectClass;
    }

    public static String getCurrentValueObjectName(XTag tag) throws XDocletException {
        String name = tag.getAttributeValue("name");
        if (name != null) {
            return name;
        }
        for (XClass clazz = ValueObjectTagsHandler.getCurrentClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Iterator i = clazz.getDoc().getTags(tag.getName()).iterator();
            while (i.hasNext()) {
                if (!tag.equals(i.next())) continue;
                name = EjbTagsHandler.getEjbNameFor(clazz);
                if (name == null) {
                    throw new XDocletException("unable to determine value object name in class " + clazz.getName());
                }
                return name;
            }
        }
        throw new XDocletException("class defining value object is not EJB");
    }

    public static String getCurrentValueObjectAttribute(XTag tag) throws XDocletException {
        String name = ValueObjectTagsHandler.getCurrentValueObjectName(tag);
        String _currentValueObjectAttribute = name == null ? "Value" : MessageFormat.format(ValueObjectTagsHandler.getSubTask().getValueObjectClassPattern(), name);
        return _currentValueObjectAttribute;
    }

    public static String getCurrentValueObjectMatch(XTag tag) {
        String match = tag.getAttributeValue("match");
        if (match == null) {
            match = "*";
        }
        return match;
    }

    public static String getCurrentValueObjectImplements(XTag tag) {
        String toImplement = tag.getAttributeValue("implements");
        return toImplement != null ? "," + toImplement : "";
    }

    private static ValueObjectSubTask getSubTask() {
        ValueObjectSubTask subtask = (ValueObjectSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName((Class)(class$xdoclet$modules$ejb$entity$ValueObjectSubTask == null ? (class$xdoclet$modules$ejb$entity$ValueObjectSubTask = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectSubTask")) : class$xdoclet$modules$ejb$entity$ValueObjectSubTask)));
        return subtask;
    }

    public boolean isAbstractValueObject(String valueObjectName, XClass currentClass) throws XDocletException {
        boolean isAbstract = false;
        List valueObjectTags = currentClass.getDoc().getTags("ejb:value-object");
        Iterator i = valueObjectTags.iterator();
        while (i.hasNext() && !isAbstract) {
            XTag tag = (XTag)i.next();
            isAbstract = this.isAbstractValueObject(valueObjectName, tag);
        }
        return isAbstract;
    }

    public String getValueMostSuperObjectClass(XClass clazz) throws XDocletException {
        String currentDataClass = this.currentValueObjectClass;
        XClass cur_clazz = clazz.getSuperclass();
        block0: do {
            List methods = cur_clazz.getMethods();
            boolean found = false;
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                XMethod method = (XMethod)j.next();
                if (method.getName().equals("get" + this.currentValueObjectAttribute)) {
                    found = true;
                    currentDataClass = ValueObjectTagsHandler.getCurrentValueObjectClass(cur_clazz, this.currentTag);
                }
                if (!found) continue;
                continue block0;
            }
        } while ((cur_clazz = cur_clazz.getSuperclass()) != null);
        return currentDataClass;
    }

    public void ifIsAbstractValueObject(String template) throws XDocletException {
        if (this.isAbstractValueObject(this.valueObjectName(), ValueObjectTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifNotIsAbstractValueObject(String template) throws XDocletException {
        if (!this.isAbstractValueObject(this.valueObjectName(), ValueObjectTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public String valueObjectClass() throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectClass();
    }

    public String valueObjectName() throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectName();
    }

    public String valueObjectMatch() throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectMatch();
    }

    public String extendsFrom(Properties attributes) throws XDocletException {
        String extendsFrom = null;
        String valueObjectName = attributes.getProperty("valueobject", this.valueObjectName());
        XClass currentClass = ValueObjectTagsHandler.getCurrentClass();
        List valueObjectTags = currentClass.getDoc().getTags("ejb:value-object");
        Iterator i = valueObjectTags.iterator();
        while (i.hasNext() && extendsFrom == null) {
            XTag tag = (XTag)i.next();
            String attr = tag.getAttributeValue("extends");
            if (!valueObjectName.equals(tag.getAttributeValue("name")) || attr == null) continue;
            extendsFrom = attr;
        }
        return extendsFrom != null ? extendsFrom : "java.lang.Object";
    }

    public void forAllValueObjects(String pTemplate) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler == null ? (class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectTagsHandler")) : class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler), (String)"forAllValueObjects");
        List dos = ValueObjectTagsHandler.getCurrentClass().getDoc().getTags("ejb:value-object", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of tags ejb:value-object in " + ValueObjectTagsHandler.getCurrentClass() + " = " + dos.size()));
        }
        Iterator i = dos.iterator();
        while (i.hasNext()) {
            this.currentTag = (XTag)i.next();
            if (this.isAbstractValueObject(ValueObjectTagsHandler.getCurrentValueObjectName(this.currentTag), this.currentTag)) continue;
            this.currentValueObjectClass = ValueObjectTagsHandler.getCurrentValueObjectClass(ValueObjectTagsHandler.getCurrentClass(), this.currentTag);
            this.currentValueObjectAttribute = ValueObjectTagsHandler.getCurrentValueObjectAttribute(this.currentTag);
            this.currentValueObjectMatch = ValueObjectTagsHandler.getCurrentValueObjectMatch(this.currentTag);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generate for " + this.currentValueObjectClass + " attr=" + this.currentValueObjectAttribute + " match=" + this.currentValueObjectMatch));
            }
            this.generate(pTemplate);
        }
    }

    public String currentValueObjectClass() {
        return this.currentValueObjectClass;
    }

    public String currentValueObjectAttribute() {
        return this.currentValueObjectAttribute;
    }

    public String currentValueObjectMatch() {
        return this.currentValueObjectMatch;
    }

    public String currentAggregateType(Properties attributes) {
        String sh = attributes.getProperty("short");
        String ret = "";
        if (sh == null) {
            ret = this.currentAggregateType;
        } else {
            StringTokenizer st = new StringTokenizer(this.currentAggregateType, ".");
            while (st.hasMoreTokens()) {
                ret = st.nextToken();
            }
        }
        return ret;
    }

    public String valueObjectImplements() {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectImplements();
    }

    public String currentAggregateName() {
        return this.currentAggregateName;
    }

    public String currentRelationBeanClass() {
        return this.currentRelationBeanClass;
    }

    public String concreteCollectionType() throws XDocletException {
        String currentReturnType = ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName();
        String res = null;
        if (currentReturnType.equals("java.util.Collection")) {
            res = "java.util.ArrayList";
        } else if (currentReturnType.equals("java.util.Set")) {
            res = "java.util.HashSet";
        } else {
            throw new XDocletException("Invalid return type (" + currentReturnType + " on aggregate or composition.");
        }
        return res;
    }

    public String valueMostSuperObjectClass() throws XDocletException {
        return this.getValueMostSuperObjectClass(ValueObjectTagsHandler.getCurrentClass());
    }

    public void forAllSuperSetValue(String template) throws XDocletException {
        XClass oldClass = ValueObjectTagsHandler.getCurrentClass();
        XClass superclass = null;
        do {
            List dos = ValueObjectTagsHandler.getCurrentClass().getDoc().getTags("ejb:value-object", false);
            Iterator i = dos.iterator();
            while (i.hasNext()) {
                this.currentTag = (XTag)i.next();
                this.currentValueObjectClass = ValueObjectTagsHandler.getCurrentValueObjectClass(ValueObjectTagsHandler.getCurrentClass(), this.currentTag);
                this.currentValueObjectAttribute = ValueObjectTagsHandler.getCurrentValueObjectAttribute(this.currentTag);
                this.currentValueObjectMatch = ValueObjectTagsHandler.getCurrentValueObjectMatch(this.currentTag);
                this.forAllSetters(template, "set" + this.currentValueObjectAttribute);
            }
            superclass = ValueObjectTagsHandler.getCurrentClass().getSuperclass();
            if (superclass == null) continue;
            ValueObjectTagsHandler.pushCurrentClass((XClass)superclass);
        } while (superclass != null);
        ValueObjectTagsHandler.setCurrentClass((XClass)oldClass);
    }

    public void forAllAggregates(String template, Properties attributes) throws XDocletException {
        String superclasses_str = attributes.getProperty("superclasses");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)superclasses_str, (boolean)true);
        String valueObject = attributes.getProperty("valueobject");
        this.forAllRelations(template, superclasses, valueObject, "aggregate");
    }

    public void forAllComposes(String template, Properties attributes) throws XDocletException {
        String superclasses_str = attributes.getProperty("superclasses");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)superclasses_str, (boolean)true);
        String valueObject = attributes.getProperty("valueobject");
        this.forAllRelations(template, superclasses, valueObject, "compose");
    }

    public void forAllRelations(String template, Properties attributes) throws XDocletException {
        String superclasses_str = attributes.getProperty("superclasses");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)superclasses_str, (boolean)true);
        String valueObject = attributes.getProperty("valueobject");
        this.forAllRelations(template, superclasses, valueObject, "aggregate");
        this.forAllRelations(template, superclasses, valueObject, "compose");
    }

    public void ifUsingValueObject(String template) throws XDocletException {
        if (DocletContext.getInstance().isSubTaskDefined(DocletTask.getSubTaskName((Class)(class$xdoclet$modules$ejb$entity$ValueObjectSubTask == null ? (class$xdoclet$modules$ejb$entity$ValueObjectSubTask = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectSubTask")) : class$xdoclet$modules$ejb$entity$ValueObjectSubTask)))) {
            this.generate(template);
        }
    }

    protected void forAllSetters(String template, String methodName) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler == null ? (class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectTagsHandler")) : class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler), (String)"forAllSetters");
        if (log.isDebugEnabled()) {
            log.debug((Object)methodName);
        }
        List methods = ValueObjectTagsHandler.getCurrentClass().getMethods();
        XMethod methodFound = null;
        Iterator j = methods.iterator();
        while (j.hasNext()) {
            XMethod method = (XMethod)j.next();
            if (method.getName().equals(methodName)) {
                methodFound = method;
            }
            if (methodFound == null) continue;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)methodFound);
            break;
        }
        if (methodFound != null) {
            this.generate(template);
        }
    }

    private boolean isAbstractValueObject(String valueObjectName, XTag tag) {
        boolean isAbstract = false;
        String attr = tag.getAttributeValue("abstract");
        if (valueObjectName.equals(tag.getAttributeValue("name")) && attr != null) {
            isAbstract = TypeConversionUtil.stringToBoolean((String)attr, (boolean)false);
        }
        return isAbstract;
    }

    private void forAllRelations(String template, boolean superclasses, String valueObject, String type) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler == null ? (class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler = ValueObjectTagsHandler.class$("xdoclet.modules.ejb.entity.ValueObjectTagsHandler")) : class$xdoclet$modules$ejb$entity$ValueObjectTagsHandler), (String)"forAllRelations");
        HashMap<String, String> foundFields = new HashMap<String, String>();
        XClass currentClass = ValueObjectTagsHandler.getCurrentClass();
        XMethod oldMethod = ValueObjectTagsHandler.getCurrentMethod();
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** forAllRelations on class=" + currentClass.getName() + " valueobject=" + valueObject));
        }
        while (true) {
            ValueObjectTagsHandler.pushCurrentClass((XClass)currentClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("****** CurrentClass=" + ValueObjectTagsHandler.getCurrentClass()));
            }
            List methods = ValueObjectTagsHandler.getCurrentClass().getMethods();
            Iterator j = methods.iterator();
            block1: while (j.hasNext()) {
                XMethod method = (XMethod)j.next();
                ValueObjectTagsHandler.setCurrentMethod((XMethod)method);
                if (!MethodTagsHandler.isGetter((String)ValueObjectTagsHandler.getCurrentMethod().getName()) || foundFields.containsKey(ValueObjectTagsHandler.getCurrentMethod().getName()) || !ValueObjectTagsHandler.isValueObjectRelation(ValueObjectTagsHandler.getCurrentMethod(), valueObject)) continue;
                boolean ret = ValueObjectTagsHandler.getCurrentMethod().getDoc().hasTag("ejb:value-object");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("****** Method " + ValueObjectTagsHandler.getCurrentMethod().getName() + " has VO tag : " + ret));
                }
                if (!ret) continue;
                List tags = ValueObjectTagsHandler.getCurrentMethod().getDoc().getTags("ejb:value-object");
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    XTag tag = (XTag)i.next();
                    String aggreg = tag.getAttributeValue(type);
                    String aggregName = tag.getAttributeValue(type + "-name");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("********* " + method.getName() + " ejb:value-object Tag - Type = " + type + " - Value = " + aggreg + " - Name = " + aggregName));
                    }
                    if (aggreg == null) continue;
                    String currentReturnType = ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("********* METHOD=" + ValueObjectTagsHandler.getCurrentMethod().getName() + " " + currentReturnType));
                    }
                    foundFields.put(ValueObjectTagsHandler.getCurrentMethod().getName(), ValueObjectTagsHandler.getCurrentMethod().getName());
                    if (currentReturnType.equals("java.util.Collection") || currentReturnType.equals("java.util.Set")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"********* Type Collection or Set");
                        }
                        this.currentAggregateType = aggreg;
                        this.currentAggregateName = aggregName;
                        String relationInterface = tag.getAttributeValue("members");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)relationInterface);
                        }
                        if (relationInterface != null && !relationInterface.equals("")) {
                            this.currentRelationBeanClass = InterfaceTagsHandler.getBeanClassNameFromInterfaceNameFor(relationInterface);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("********* Type " + ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().toString()));
                        }
                        this.currentAggregateType = aggreg;
                        this.currentAggregateName = aggregName;
                        this.currentRelationBeanClass = InterfaceTagsHandler.getBeanClassNameFromInterfaceNameFor(ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName());
                    }
                    this.generate(template);
                    this.currentAggregateType = null;
                    this.currentAggregateName = null;
                    this.currentRelationBeanClass = null;
                    continue block1;
                }
            }
            XClass superclass = ValueObjectTagsHandler.getCurrentClass().getSuperclass();
            if (superclass == null) {
                ValueObjectTagsHandler.popCurrentClass();
                break;
            }
            if (superclass.getQualifiedName().equals("java.lang.Object")) {
                ValueObjectTagsHandler.popCurrentClass();
                break;
            }
            ValueObjectTagsHandler.popCurrentClass();
            if (superclasses) {
                currentClass = currentClass.getSuperclass();
                continue;
            }
            if (!this.shouldTraverseSuperclassForDependentClass(currentClass.getSuperclass(), this.getDependentClassTagName())) break;
            currentClass = currentClass.getSuperclass();
        }
        ValueObjectTagsHandler.setCurrentMethod((XMethod)oldMethod);
        log.debug((Object)"Finished.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

