/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.jboss.logging.Logger;
import org.jboss.util.Strings;

public class JmsActivationSpec
implements ActivationSpec {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$jms$inflow$JmsActivationSpec == null ? (class$org$jboss$resource$adapter$jms$inflow$JmsActivationSpec = JmsActivationSpec.class$("org.jboss.resource.adapter.jms.inflow.JmsActivationSpec")) : class$org$jboss$resource$adapter$jms$inflow$JmsActivationSpec));
    private ResourceAdapter ra;
    private String destination;
    private boolean isTopic = false;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean subscriptionDurability;
    private String clientId;
    private String subscriptionName;
    private long reconnectInterval = 10L;
    private String providerAdapterJNDI = "java:/DefaultJMSProvider";
    private String user;
    private String pass;
    private int maxMessages = 1;
    private int minSession = 1;
    private int maxSession = 15;
    private long keepAlive = 60000L;
    private boolean sessionTransacted = true;
    private String dLQHandler = "org.jboss.resource.adapter.jms.inflow.dlq.GenericDLQHandler";
    private boolean useDLQ = true;
    private String dLQJNDIName = "queue/DLQ";
    private String dLQUser;
    private String dLQPassword;
    private String dLQClientID;
    private int dLQMaxResent;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jms$inflow$JmsActivationSpec;
    static /* synthetic */ Class class$javax$jms$Topic;
    static /* synthetic */ Class class$javax$jms$Queue;

    public String getAcknowledgeMode() {
        if (3 == this.acknowledgeMode) {
            return "DUPS_OK_ACKNOWLEDGE";
        }
        return "AUTO_ACKNOWLEDGE";
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = "DUPS_OK_ACKNOWLEDGE".equals(acknowledgeMode) ? 3 : 1;
    }

    public int getAcknowledgeModeInt() {
        return this.acknowledgeMode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationType() {
        if (this.isTopic) {
            return (class$javax$jms$Topic == null ? (class$javax$jms$Topic = JmsActivationSpec.class$("javax.jms.Topic")) : class$javax$jms$Topic).getName();
        }
        return (class$javax$jms$Queue == null ? (class$javax$jms$Queue = JmsActivationSpec.class$("javax.jms.Queue")) : class$javax$jms$Queue).getName();
    }

    public void setDestinationType(String destinationType) {
        this.isTopic = (class$javax$jms$Topic == null ? (class$javax$jms$Topic = JmsActivationSpec.class$("javax.jms.Topic")) : class$javax$jms$Topic).getName().equals(destinationType);
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public String getSubscriptionDurability() {
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = "Durable".equals(subscriptionDurability);
    }

    public boolean isDurable() {
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public long getReconnectIntervalLong() {
        return this.reconnectInterval * 1000L;
    }

    public String getProviderAdapterJNDI() {
        return this.providerAdapterJNDI;
    }

    public void setProviderAdapterJNDI(String providerAdapterJNDI) {
        this.providerAdapterJNDI = providerAdapterJNDI;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.pass;
    }

    public void setPassword(String pass) {
        this.pass = pass;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxSession = maxMessages;
    }

    public int getMaxMessagesInt() {
        return this.maxMessages;
    }

    public int getMinSession() {
        return this.minSession;
    }

    public void setMinSession(int minSession) {
        this.minSession = minSession;
    }

    public int getMinSessionInt() {
        return this.minSession;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public int getMaxSessionInt() {
        return this.maxSession;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long getKeepAliveLong() {
        return this.keepAlive;
    }

    public boolean getSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public String getDLQHandler() {
        return this.dLQHandler;
    }

    public void setDLQHandler(String handler) {
        this.dLQHandler = handler;
    }

    public String getDLQJNDIName() {
        return this.dLQJNDIName;
    }

    public void setDLQJNDIName(String name) {
        this.dLQJNDIName = name;
    }

    public boolean getUseDLQ() {
        return this.useDLQ;
    }

    public void setUseDLQ(boolean useDLQ) {
        this.useDLQ = useDLQ;
    }

    public boolean isUseDLQ() {
        return this.useDLQ;
    }

    public String getDLQClientID() {
        return this.dLQClientID;
    }

    public void setDLQClientID(String clientID) {
        this.dLQClientID = clientID;
    }

    public String getDLQPassword() {
        return this.dLQPassword;
    }

    public void setDLQPassword(String password) {
        this.dLQPassword = password;
    }

    public String getDLQUser() {
        return this.dLQUser;
    }

    public void setDLQUser(String user) {
        this.dLQUser = user;
    }

    public int getDLQMaxResent() {
        return this.dLQMaxResent;
    }

    public void setDLQMaxResent(int maxResent) {
        this.dLQMaxResent = maxResent;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        this.ra = ra;
    }

    public void validate() throws InvalidPropertyException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("validate " + this));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Strings.defaultToString((Object)this)).append('(');
        buffer.append("ra=").append(this.ra);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" isTopic=").append(this.isTopic);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" tx=").append(this.sessionTransacted);
        buffer.append(" ack=").append(this.getAcknowledgeMode());
        buffer.append(" durable=").append(this.subscriptionDurability);
        if (this.clientId != null) {
            buffer.append(" clientID=").append(this.clientId);
        }
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" reconnect=").append(this.reconnectInterval);
        buffer.append(" provider=").append(this.providerAdapterJNDI);
        buffer.append(" user=").append(this.user);
        if (this.pass != null) {
            buffer.append(" pass=").append("<not shown>");
        }
        buffer.append(" maxMessages=").append(this.maxMessages);
        buffer.append(" minSession=").append(this.minSession);
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(" keepAlive=").append(this.keepAlive);
        buffer.append(" useDLQ=").append(this.useDLQ);
        if (this.useDLQ) {
            buffer.append(" DLQHandler=").append(this.dLQHandler);
            buffer.append(" DLQJndiName=").append(this.dLQJNDIName);
            buffer.append(" DLQUser=").append(this.dLQUser);
            if (this.dLQPassword != null) {
                buffer.append(" DLQPass=").append("<not shown>");
            }
            if (this.dLQClientID != null) {
                buffer.append(" DLQClientID=").append(this.dLQClientID);
            }
            buffer.append(" DLQMaxResent=").append(this.dLQMaxResent);
        }
        buffer.append(')');
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

