/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import [Ljava.lang.Byte;;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.axis.Constants;
import org.jboss.axis.description.ElementDesc;
import org.jboss.axis.description.FieldDesc;
import org.jboss.axis.description.TypeDesc;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.encoding.TypeMapping;
import org.jboss.axis.encoding.ser.ArrayDeserializer;
import org.jboss.axis.encoding.ser.Base64Deserializer;
import org.jboss.axis.encoding.ser.BeanDeserializerFactory;
import org.jboss.axis.encoding.ser.BeanPropertyTarget;
import org.jboss.axis.encoding.ser.DeferedBeanConstruction;
import org.jboss.axis.encoding.ser.HexDeserializer;
import org.jboss.axis.encoding.ser.SimpleDeserializer;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.message.SOAPHandler;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.BeanPropertyDescriptor;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends DeserializerImpl {
    private static Logger log = Logger.getLogger((String)BeanDeserializer.class.getName());
    QName xmlType;
    Class javaType;
    protected Map propertyMap;
    protected QName prevQName;
    protected TypeDesc typeDesc = null;
    protected int collectionIndex = -1;
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;
    protected String lastFieldName = null;
    protected DeferedBeanConstruction deferedConstruction;

    public BeanDeserializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this(javaType, xmlType, typeDesc, BeanDeserializerFactory.getProperties(javaType, typeDesc));
    }

    public BeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc, Map propertyMap) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyMap = propertyMap;
        try {
            this.value = javaType.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        block13: {
            this.lastFieldName = null;
            if (this.value == null) {
                try {
                    this.value = this.javaType.newInstance();
                }
                catch (Exception e) {
                    ArrayList<Class> propTypes = new ArrayList<Class>();
                    Iterator it = this.propertyMap.values().iterator();
                    while (it.hasNext()) {
                        BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)it.next();
                        propTypes.add(bpd.getType());
                    }
                    Constructor<?>[] ctors = this.javaType.getConstructors();
                    this.deferedConstruction = null;
                    for (int i = 0; this.deferedConstruction == null && i < ctors.length; ++i) {
                        Constructor<?> ctor = ctors[i];
                        Class<?>[] ctorArgs = ctor.getParameterTypes();
                        if (ctorArgs.length <= 0) continue;
                        boolean allFound = true;
                        for (int j = 0; j < ctorArgs.length; ++j) {
                            allFound &= propTypes.contains(ctorArgs[j]);
                        }
                        if (!allFound) continue;
                        this.deferedConstruction = new DeferedBeanConstruction(ctor);
                    }
                    if (this.value != null || this.deferedConstruction != null) break block13;
                    throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
                }
            }
        }
        if (this.typeDesc == null) {
            return;
        }
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        String soapenvURI = soapConstants.getEnvelopeURI();
        for (int i = 0; i < attributes.getLength(); ++i) {
            BeanPropertyDescriptor bpd;
            QName attrQName = null;
            attrQName = soapenvURI.equals(attributes.getURI(i)) ? new QName(attributes.getLocalName(i)) : new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName == null || (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) == null || bpd.isIndexed()) continue;
            Deserializer dSer = this.getDeserializer(null, bpd.getType(), null, context);
            if (dSer == null) {
                throw new SAXException(Messages.getMessage("unregistered00", bpd.getType().toString()));
            }
            if (!(dSer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", bpd.getName(), bpd.getType().toString()));
            }
            try {
                dSer.onStartElement(namespace, localName, prefix, attributes, context);
                Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                if (this.value != null) {
                    bpd.set(this.value, val);
                    continue;
                }
                if (this.deferedConstruction == null) continue;
                this.value = this.deferedConstruction.newBeanInstance(val);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        Deserializer dSer;
        log.debug((Object)("onStartChild: " + new QName(namespace, localName)));
        BeanPropertyDescriptor propDesc = null;
        FieldDesc fieldDesc = null;
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        String encodingStyle = context.getMessageContext().getEncodingStyle();
        boolean isEncoded = Constants.isSOAP_ENC(encodingStyle);
        QName elemQName = new QName(namespace, localName);
        if (this.prevQName == null || !this.prevQName.equals(elemQName)) {
            this.collectionIndex = -1;
        }
        this.prevQName = elemQName;
        if (this.typeDesc != null) {
            String fieldName = this.typeDesc.getFieldNameForElement(elemQName);
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
            fieldDesc = this.typeDesc.getFieldByName(fieldName);
            this.lastFieldName = fieldName;
        } else {
            this.lastFieldName = null;
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(localName);
        }
        if (propDesc == null && (propDesc = this.getAnyPropertyDesc()) != null) {
            try {
                SOAPElementAxisImpl thisEl;
                SOAPElementAxisImpl[] curElements = (SOAPElementAxisImpl[])propDesc.get(this.value);
                int length = 0;
                if (curElements != null) {
                    length = curElements.length;
                }
                SOAPElementAxisImpl[] newElements = new SOAPElementAxisImpl[length + 1];
                if (curElements != null) {
                    System.arraycopy(curElements, 0, newElements, 0, length);
                }
                newElements[length] = thisEl = context.getCurElement();
                propDesc.set(this.value, newElements);
                if (!localName.equals(thisEl.getName())) {
                    return new SOAPHandler(newElements, length);
                }
                return new SOAPHandler();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (propDesc == null) {
            throw new SAXException(Messages.getMessage("badElem00", this.javaType.getName(), localName));
        }
        QName childXMLType = context.getTypeFromXSITypeAttr(namespace, localName, attributes);
        String href = attributes.getValue(soapConstants.getAttrHref());
        if (childXMLType == null && fieldDesc != null && href == null) {
            childXMLType = fieldDesc.getXmlType();
        }
        Class propType = propDesc.getType();
        TypeMapping tm = context.getTypeMapping();
        Class childType = tm.getClassForQName(childXMLType);
        if (childType != null && propType.isAssignableFrom(childType)) {
            propType = childType;
        }
        if ((dSer = this.getDeserializer(childXMLType, propType, href, context)) == null) {
            dSer = new DeserializerImpl();
            return (SOAPHandler)((Object)dSer);
        }
        if (propDesc.isWriteable() || this.deferedConstruction != null) {
            if (propDesc.isIndexed() && !(dSer instanceof ArrayDeserializer)) {
                ++this.collectionIndex;
                dSer.registerValueTarget(this.getBeanPropertyTarget(propDesc));
            } else if (!isEncoded && JavaUtils.isArrayClass(propDesc.getType()) && !(dSer instanceof Base64Deserializer) && !(dSer instanceof HexDeserializer)) {
                ++this.collectionIndex;
                dSer.registerValueTarget(this.getBeanPropertyTarget(propDesc));
            } else {
                this.collectionIndex = -1;
                dSer.registerValueTarget(this.getBeanPropertyTarget(propDesc));
            }
        }
        this.addChildDeserializer(dSer);
        return (SOAPHandler)((Object)dSer);
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        super.onEndElement(namespace, localName, context);
        if (this.value == null && this.deferedConstruction != null) {
            throw new SAXException("Could not construct bean using: " + this.deferedConstruction);
        }
    }

    private BeanPropertyTarget getBeanPropertyTarget(BeanPropertyDescriptor propDesc) {
        BeanPropertyTarget target = null;
        if (this.value != null) {
            target = new BeanPropertyTarget(this.value, propDesc, this.collectionIndex);
        } else if (this.deferedConstruction != null) {
            target = new BeanPropertyTarget(this, this.deferedConstruction, propDesc);
        } else {
            throw new IllegalStateException("Cannot get a valid property target");
        }
        return target;
    }

    public BeanPropertyDescriptor getAnyPropertyDesc() {
        if (this.typeDesc == null) {
            return null;
        }
        return this.typeDesc.getAnyDesc();
    }

    protected Deserializer getDeserializer(QName xmlType, Class javaType, String href, DeserializationContext context) {
        String encodingStyle = context.getMessageContext().getEncodingStyle();
        boolean isEncoded = Constants.isSOAP_ENC(encodingStyle);
        if (this.cacheStringDSer != null && String.class.equals(javaType) && href == null && (this.cacheXMLType == null && xmlType == null || this.cacheXMLType != null && this.cacheXMLType.equals(xmlType))) {
            this.cacheStringDSer.reset();
            return this.cacheStringDSer;
        }
        Deserializer dSer = null;
        TypeMapping tm = context.getTypeMapping();
        if (xmlType != null && href == null) {
            dSer = context.getDeserializerForType(xmlType);
        }
        if (dSer == null) {
            QName defaultXMLType = tm.getTypeQName(javaType);
            if (href == null) {
                dSer = context.getDeserializer(javaType, defaultXMLType);
            } else {
                dSer = new DeserializerImpl();
                dSer.setDefaultType(defaultXMLType);
            }
        }
        if (javaType.equals(String.class) && dSer instanceof SimpleDeserializer) {
            this.cacheStringDSer = (SimpleDeserializer)dSer;
            this.cacheXMLType = xmlType;
        }
        if (dSer == null && !isEncoded && JavaUtils.isArrayClass(javaType) && javaType != Byte;.class && javaType != [B.class) {
            FieldDesc fieldDesc = this.lastFieldName != null ? this.typeDesc.getFieldByName(this.lastFieldName) : null;
            Class<?> compType = javaType.getComponentType();
            QName itemXmlType = null;
            if (fieldDesc != null && fieldDesc instanceof ElementDesc) {
                itemXmlType = ((ElementDesc)fieldDesc).getItemXmlType();
            }
            if (itemXmlType == null) {
                itemXmlType = tm.getTypeQName(compType);
            }
            log.debug((Object)("Using itemXmlType = " + itemXmlType));
            dSer = context.getDeserializer(compType, itemXmlType);
        }
        return dSer;
    }

    public void characters(char[] p1, int p2, int p3) throws SAXException {
        super.characters(p1, p2, p3);
        if (this.typeDesc != null) {
            Iterator it = this.propertyMap.values().iterator();
            while (it.hasNext()) {
                String name;
                FieldDesc fieldDesc;
                BeanPropertyDescriptor bpDesc = (BeanPropertyDescriptor)it.next();
                if (!bpDesc.isWriteable() || !((fieldDesc = this.typeDesc.getFieldByName(name = bpDesc.getName())) instanceof ElementDesc) || !((ElementDesc)fieldDesc).isAsContent()) continue;
                String strContent = new String(p1, p2, p3);
                try {
                    log.debug((Object)("Setting content property: " + name + "=" + strContent));
                    bpDesc.set(this.value, strContent);
                }
                catch (Exception e) {
                    log.warn((Object)"Cannot set content property", (Throwable)e);
                }
            }
        }
    }
}

