/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import com.sun.mail.util.LineInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.SecuritySupport;
import javax.mail.Store;
import javax.mail.StreamLoader;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private final Properties props;
    private final Authenticator authenticator;
    private final Hashtable authTable = new Hashtable();
    private boolean debug = false;
    private PrintStream out;
    private final Vector providers = new Vector();
    private final Hashtable providersByProtocol = new Hashtable();
    private final Hashtable providersByClassName = new Hashtable();
    private final Properties addressMap = new Properties();
    private static Session defaultSession = null;
    private static final String version = "1.3.1";
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$javax$mail$URLName;

    private Session(Properties properties, Authenticator authenticator) {
        this.props = properties;
        this.authenticator = authenticator;
        if (Boolean.valueOf(properties.getProperty("mail.debug")).booleanValue()) {
            this.debug = true;
        }
        if (this.debug) {
            this.pr("DEBUG: JavaMail version 1.3.1");
        }
        Class<?> clazz = authenticator != null ? authenticator.getClass() : this.getClass();
        this.loadProviders(clazz);
        this.loadAddressMap(clazz);
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        return new Session(properties, authenticator);
    }

    public static Session getInstance(Properties properties) {
        return new Session(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (defaultSession == null) {
            defaultSession = new Session(properties, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access to default session denied");
        }
        return defaultSession;
    }

    public static Session getDefaultInstance(Properties properties) {
        return Session.getDefaultInstance(properties, null);
    }

    public synchronized void setDebug(boolean bl) {
        this.debug = bl;
        if (bl) {
            this.pr("DEBUG: setDebug: JavaMail version 1.3.1");
        }
    }

    public synchronized boolean getDebug() {
        return this.debug;
    }

    public synchronized void setDebugOut(PrintStream printStream) {
        this.out = printStream;
    }

    public synchronized PrintStream getDebugOut() {
        if (this.out == null) {
            return System.out;
        }
        return this.out;
    }

    public synchronized Provider[] getProviders() {
        Object[] objectArray = new Provider[this.providers.size()];
        this.providers.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Provider getProvider(String string) throws NoSuchProviderException {
        if (string == null || string.length() <= 0) {
            throw new NoSuchProviderException("Invalid protocol: null");
        }
        Provider provider = null;
        String string2 = this.props.getProperty("mail." + string + ".class");
        if (string2 != null) {
            if (this.debug) {
                this.pr("DEBUG: mail." + string + ".class property exists and points to " + string2);
            }
            provider = (Provider)this.providersByClassName.get(string2);
        }
        if (provider != null) {
            return provider;
        }
        provider = (Provider)this.providersByProtocol.get(string);
        if (provider == null) {
            throw new NoSuchProviderException("No provider for " + string);
        }
        if (this.debug) {
            this.pr("DEBUG: getProvider() returning " + provider.toString());
        }
        return provider;
    }

    public synchronized void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        this.providersByProtocol.put(provider.getProtocol(), provider);
        ((Hashtable)this.props).put("mail." + provider.getProtocol() + ".class", provider.getClassName());
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Store getStore(String string) throws NoSuchProviderException {
        return this.getStore(new URLName(string, null, -1, null, null, null));
    }

    public Store getStore(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getStore(provider, uRLName);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    private Store getStore(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Store)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        Store store = this.getStore(uRLName);
        store.connect();
        return store.getFolder(uRLName);
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this.getProperty("mail.transport.protocol"));
    }

    public Transport getTransport(String string) throws NoSuchProviderException {
        return this.getTransport(new URLName(string, null, -1, null, null, null));
    }

    public Transport getTransport(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getTransport(provider, uRLName);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String string = (String)((Hashtable)this.addressMap).get(address.getType());
        if (string == null) {
            throw new NoSuchProviderException("No provider for Address type: " + address.getType());
        }
        return this.getTransport(string);
    }

    private Transport getTransport(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Transport)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    private Object getService(Provider provider, URLName uRLName) throws NoSuchProviderException {
        Class[] classArray;
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (uRLName == null) {
            uRLName = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Object var3_3 = null;
        ClassLoader classLoader = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        Class<?> clazz = null;
        try {
            classArray = SecuritySupport.getInstance().getContextClassLoader();
            if (classArray != null) {
                try {
                    clazz = classArray.loadClass(provider.getClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (clazz == null) {
                clazz = classLoader.loadClass(provider.getClassName());
            }
        }
        catch (Exception exception) {
            try {
                clazz = Class.forName(provider.getClassName());
            }
            catch (Exception exception2) {
                if (this.debug) {
                    exception2.printStackTrace(this.getDebugOut());
                }
                throw new NoSuchProviderException(provider.getProtocol());
            }
        }
        try {
            classArray = new Class[]{class$javax$mail$Session != null ? class$javax$mail$Session : (class$javax$mail$Session = Session.class$("javax.mail.Session")), class$javax$mail$URLName != null ? class$javax$mail$URLName : (class$javax$mail$URLName = Session.class$("javax.mail.URLName"))};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, uRLName};
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace(this.getDebugOut());
            }
            throw new NoSuchProviderException(provider.getProtocol());
        }
        return var3_3;
    }

    public void setPasswordAuthentication(URLName uRLName, PasswordAuthentication passwordAuthentication) {
        if (passwordAuthentication == null) {
            this.authTable.remove(uRLName);
            return;
        }
        this.authTable.put(uRLName, passwordAuthentication);
    }

    public PasswordAuthentication getPasswordAuthentication(URLName uRLName) {
        return (PasswordAuthentication)this.authTable.get(uRLName);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(inetAddress, n, string, string2, string3);
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    private void loadProviders(Class clazz) {
        1 var2_2;
        block5: {
            var2_2 = new 1();
            try {
                String string = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javamail.providers";
                this.loadFile(string, var2_2);
            }
            catch (SecurityException securityException) {
                if (!this.debug) break block5;
                this.pr("DEBUG: can't get java.home: " + securityException);
            }
        }
        this.loadAllResources("META-INF/javamail.providers", clazz, var2_2);
        this.loadResource("/META-INF/javamail.default.providers", clazz, var2_2);
        if (this.providers.size() == 0) {
            if (this.debug) {
                this.pr("DEBUG: failed to load any providers, using defaults");
            }
            this.addProvider(new Provider(Provider.Type.STORE, "imap", "com.sun.mail.imap.IMAPStore", "Sun Microsystems, Inc.", version));
            this.addProvider(new Provider(Provider.Type.STORE, "pop3", "com.sun.mail.pop3.POP3Store", "Sun Microsystems, Inc.", version));
            this.addProvider(new Provider(Provider.Type.TRANSPORT, "smtp", "com.sun.mail.smtp.SMTPTransport", "Sun Microsystems, Inc.", version));
        }
        if (this.debug) {
            this.pr("DEBUG: Tables of loaded providers");
            this.pr("DEBUG: Providers Listed By Class Name: " + this.providersByClassName.toString());
            this.pr("DEBUG: Providers Listed By Protocol: " + this.providersByProtocol.toString());
        }
    }

    private void loadProvidersFromStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            String string;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string = lineInputStream.readLine()) != null) {
                Object object;
                if (string.startsWith("#")) continue;
                Provider.Type type = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken().trim();
                    int n = ((String)object).indexOf("=");
                    if (((String)object).startsWith("protocol=")) {
                        string2 = ((String)object).substring(n + 1);
                        continue;
                    }
                    if (((String)object).startsWith("type=")) {
                        String string6 = ((String)object).substring(n + 1);
                        if (string6.equalsIgnoreCase("store")) {
                            type = Provider.Type.STORE;
                            continue;
                        }
                        if (!string6.equalsIgnoreCase("transport")) continue;
                        type = Provider.Type.TRANSPORT;
                        continue;
                    }
                    if (((String)object).startsWith("class=")) {
                        string3 = ((String)object).substring(n + 1);
                        continue;
                    }
                    if (((String)object).startsWith("vendor=")) {
                        string4 = ((String)object).substring(n + 1);
                        continue;
                    }
                    if (!((String)object).startsWith("version=")) continue;
                    string5 = ((String)object).substring(n + 1);
                }
                if (type == null || string2 == null || string3 == null || string2.length() <= 0 || string3.length() <= 0) {
                    if (!this.debug) continue;
                    this.pr("DEBUG: Bad provider entry: " + string);
                    continue;
                }
                object = new Provider(type, string2, string3, string4, string5);
                this.addProvider((Provider)object);
            }
        }
    }

    private void addProvider(Provider provider) {
        this.providers.addElement(provider);
        this.providersByClassName.put(provider.getClassName(), provider);
        if (!this.providersByProtocol.containsKey(provider.getProtocol())) {
            this.providersByProtocol.put(provider.getProtocol(), provider);
        }
    }

    private void loadAddressMap(Class clazz) {
        block4: {
            2 var2_2 = new 2();
            this.loadResource("/META-INF/javamail.default.address.map", clazz, var2_2);
            this.loadAllResources("META-INF/javamail.address.map", clazz, var2_2);
            try {
                String string = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javamail.address.map";
                this.loadFile(string, var2_2);
            }
            catch (SecurityException securityException) {
                if (!this.debug) break block4;
                this.pr("DEBUG: can't get java.home: " + securityException);
            }
        }
        if (((Hashtable)this.addressMap).isEmpty()) {
            if (this.debug) {
                this.pr("DEBUG: failed to load address map, using defaults");
            }
            ((Hashtable)this.addressMap).put("rfc822", "smtp");
        }
    }

    private void loadFile(String string, StreamLoader streamLoader) {
        BufferedInputStream bufferedInputStream = null;
        try {
            block15: {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                    if (bufferedInputStream != null) {
                        streamLoader.load(bufferedInputStream);
                        if (this.debug) {
                            this.pr("DEBUG: successfully loaded file: " + string);
                        }
                    } else if (this.debug) {
                        this.pr("DEBUG: not loading file: " + string);
                    }
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        this.pr("DEBUG: " + iOException);
                    }
                }
                catch (SecurityException securityException) {
                    if (!this.debug) break block15;
                    this.pr("DEBUG: " + securityException);
                }
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    private void loadResource(String string, Class clazz, StreamLoader streamLoader) {
        InputStream inputStream = null;
        try {
            block15: {
                try {
                    inputStream = SecuritySupport.getInstance().getResourceAsStream(clazz, string);
                    if (inputStream != null) {
                        streamLoader.load(inputStream);
                        if (this.debug) {
                            this.pr("DEBUG: successfully loaded resource: " + string);
                        }
                    } else if (this.debug) {
                        this.pr("DEBUG: not loading resource: " + string);
                    }
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        this.pr("DEBUG: " + iOException);
                    }
                }
                catch (SecurityException securityException) {
                    if (!this.debug) break block15;
                    this.pr("DEBUG: " + securityException);
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void loadAllResources(String string, Class clazz, StreamLoader streamLoader) {
        boolean bl;
        block22: {
            bl = false;
            try {
                URL[] uRLArray;
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getInstance().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = clazz.getClassLoader();
                }
                if ((uRLArray = classLoader != null ? SecuritySupport.getInstance().getResources(classLoader, string) : SecuritySupport.getInstance().getSystemResources(string)) == null) break block22;
                int n = 0;
                while (n < uRLArray.length) {
                    Object var11_11;
                    URL uRL = uRLArray[n];
                    InputStream inputStream = null;
                    if (this.debug) {
                        this.pr("DEBUG: URL " + uRL);
                    }
                    try {
                        block23: {
                            try {
                                inputStream = SecuritySupport.getInstance().openStream(uRL);
                                if (inputStream != null) {
                                    streamLoader.load(inputStream);
                                    bl = true;
                                    if (this.debug) {
                                        this.pr("DEBUG: successfully loaded resource: " + uRL);
                                    }
                                } else if (this.debug) {
                                    this.pr("DEBUG: not loading resource: " + uRL);
                                }
                            }
                            catch (IOException iOException) {
                                if (this.debug) {
                                    this.pr("DEBUG: " + iOException);
                                }
                            }
                            catch (SecurityException securityException) {
                                if (!this.debug) break block23;
                                this.pr("DEBUG: " + securityException);
                            }
                        }
                        var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block22;
                this.pr("DEBUG: " + exception);
            }
        }
        if (!bl) {
            if (this.debug) {
                this.pr("DEBUG: !anyLoaded");
            }
            this.loadResource("/" + string, clazz, streamLoader);
        }
    }

    private void pr(String string) {
        this.getDebugOut().println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    implements StreamLoader {
        public void load(InputStream inputStream) throws IOException {
            Session.this.loadProvidersFromStream(inputStream);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements StreamLoader {
        public void load(InputStream inputStream) throws IOException {
            Session.this.addressMap.load(inputStream);
        }

        /* synthetic */ 2() {
        }
    }
}

