/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.net.URL;
import java.util.Comparator;
import org.jboss.deployment.DefaultDeploymentSorter;
import org.jboss.deployment.scanner.PrefixDeploymentSorter;

public class AlphaNumericDeploymentSorter
implements Comparator,
DefaultDeploymentSorter {
    private PrefixDeploymentSorter sorter = new PrefixDeploymentSorter();

    public String[] getSuffixOrder() {
        return this.sorter.getSuffixOrder();
    }

    public void setSuffixOrder(String[] suffixOrder) {
        this.sorter.setSuffixOrder(suffixOrder);
    }

    public int compare(Object o1, Object o2) {
        int comp = this.sorter.compare(o1, o2);
        return comp == 0 ? this.alphaCompare(o1, o2) : comp;
    }

    private String convertURLToString(URL url) {
        String path = url.getPath();
        int nameEnd = path.length() - 1;
        if (nameEnd <= 0) {
            return "";
        }
        if (path.charAt(nameEnd) == '/') {
            --nameEnd;
        }
        int nameStart = path.lastIndexOf(47, nameEnd) + 1;
        return path.substring(nameStart);
    }

    public int alphaCompare(Object o1, Object o2) {
        String s1 = this.convertURLToString((URL)o1);
        boolean s1IsDigit = Character.isDigit(s1.charAt(0));
        String s2 = this.convertURLToString((URL)o2);
        boolean s2IsDigit = Character.isDigit(s2.charAt(0));
        if (s1IsDigit && !s2IsDigit) {
            return 1;
        }
        if (!s1IsDigit && s2IsDigit) {
            return -1;
        }
        if (s1IsDigit && s2IsDigit) {
            int num2;
            int num1 = this.getNumericPrefix(s1);
            int diff = num1 - (num2 = this.getNumericPrefix(s2));
            if (diff != 0) {
                return diff;
            }
            String s1Suf = this.getAlphaSuffix(s1);
            String s2Sef = this.getAlphaSuffix(s2);
            return s1Suf.compareToIgnoreCase(s2Sef);
        }
        return s1.compareToIgnoreCase(s2);
    }

    private String getAlphaSuffix(String s1) {
        int x = 0;
        while (Character.isDigit(s1.charAt(x++))) {
        }
        return s1.substring(x);
    }

    private int getNumericPrefix(String s1) {
        int x = 0;
        String numS1 = null;
        while (Character.isDigit(s1.charAt(x++))) {
            numS1 = s1.substring(0, x);
        }
        int number = Integer.parseInt(numS1);
        return number;
    }
}

