/*
 * Decompiled with CFR 0.152.
 */
package test.performance.standard;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.TestCase;
import test.performance.standard.support.Standard;

public class InvocationTEST
extends TestCase {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class array$$$Ljava$lang$Object;
    static /* synthetic */ Class class$javax$management$Attribute;

    public InvocationTEST(String s) {
        super(s);
    }

    public void testVoidInvocationWithDefaultDomain() {
        try {
            System.out.println("\nSTANDARD: void invocation with DefaultDomain");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName(":performanceTest=standard");
            String method = "methodInvocation";
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(new Standard(), name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, null, null);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            InvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testVoidInvocation() {
        try {
            System.out.println("\nSTANDARD: void invocation");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName("Domain:performanceTest=standard");
            String method = "methodInvocation";
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(new Standard(), name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, null, null);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            InvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testCounterInvocation() {
        try {
            System.out.println("\nSTANDARD: counter invocation");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName("Domain:performanceTest=standard");
            Standard mbean = new Standard();
            String method = "counter";
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(mbean, name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, null, null);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
            InvocationTEST.assertTrue((mbean.getCount() == 1100000 ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            InvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testMixedArgsInvocation() {
        try {
            System.out.println("\nSTANDARD: mixed arguments invocation");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName("Domain:performanceTest=standard");
            Standard mbean = new Standard();
            String method = "mixedArguments";
            String[] signature = new String[]{(class$java$lang$Integer == null ? (class$java$lang$Integer = InvocationTEST.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), Integer.TYPE.getName(), (array$$$Ljava$lang$Object == null ? (array$$$Ljava$lang$Object = InvocationTEST.class$("[[[Ljava.lang.Object;")) : array$$$Ljava$lang$Object).getName(), (class$javax$management$Attribute == null ? (class$javax$management$Attribute = InvocationTEST.class$("javax.management.Attribute")) : class$javax$management$Attribute).getName()};
            Object[] args = new Object[]{new Integer(1234), new Integer(455617), new Object[][][]{{{"1x1x1", "1x1x2", "1x1x3"}, {"1x2x1", "1x2x2", "1x2x3"}, {"1x3x1", "1x3x2", "1x3x3"}}, {{"2x1x1", "2x1x2", "2x1x3"}, {"2x2x1", "2x2x2", "2x2x3"}, {"2x3x1", "2x3x2", "2x3x3"}}, {{"3x1x1", "3x1x2", "3x1x3"}, {"3x2x1", "3x2x2", "3x2x3"}, {"3x3x1", "3x3x2", "3x3x3"}}}, new Attribute("attribute", "value")};
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(mbean, name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, args, signature);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            InvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

