/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.timer;

import java.util.ArrayList;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.management.timer.TimerNotification;
import junit.framework.TestCase;

public class TimerNotificationTestCase
extends TestCase
implements NotificationListener {
    String TIMER_TYPE = "TimerType";
    String MESSAGE = "Message";
    String USER_DATA = "UserData";
    MBeanServer server;
    ObjectName timerName;
    Timer timer;
    Integer id;
    ArrayList notifications = new ArrayList();

    public TimerNotificationTestCase(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReasonableValues() {
        this.initTest();
        try {
            this.initTimer();
            this.startTimer();
            long startTime = this.timeOffset(0L).getTime();
            this.addNotification(100L);
            this.sync();
            this.stopTimer();
            long endTime = this.timeOffset(0L).getTime();
            TimerNotificationTestCase.assertEquals((int)1, (int)this.notifications.size());
            TimerNotification tn = (TimerNotification)this.notifications.get(0);
            TimerNotificationTestCase.assertEquals((String)this.MESSAGE, (String)tn.getMessage());
            TimerNotificationTestCase.assertEquals((long)1L, (long)tn.getSequenceNumber());
            TimerNotificationTestCase.assertEquals((Object)this.timerName, (Object)tn.getSource());
            TimerNotificationTestCase.assertEquals((String)this.TIMER_TYPE, (String)tn.getType());
            TimerNotificationTestCase.assertEquals((Object)this.USER_DATA, (Object)tn.getUserData());
            TimerNotificationTestCase.assertEquals((Object)this.id, (Object)tn.getNotificationID());
            if (tn.getTimeStamp() < startTime + 100L) {
                TimerNotificationTestCase.fail((String)"Timer notification before start?");
            }
            if (tn.getTimeStamp() > endTime) {
                TimerNotificationTestCase.fail((String)"Timer notification after end?");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    private void initTest() {
        this.notifications.clear();
        this.server = MBeanServerFactory.createMBeanServer();
    }

    private void initTimer() {
        try {
            this.timer = new Timer();
            this.timerName = new ObjectName("test:type=timer");
            this.server.registerMBean(this.timer, this.timerName);
            this.server.addNotificationListener(this.timerName, this, null, null);
        }
        catch (Exception e) {
            TimerNotificationTestCase.fail((String)e.toString());
        }
    }

    private void startTimer() {
        this.timer.start();
    }

    private void stopTimer() {
        this.sleep();
        this.timer.stop();
    }

    private void addNotification(long offset) {
        this.id = this.timer.addNotification(this.TIMER_TYPE, this.MESSAGE, this.USER_DATA, this.timeOffset(100L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification n, Object ignored) {
        this.notifications.add(n);
        ArrayList arrayList = this.notifications;
        synchronized (arrayList) {
            this.notifications.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        ArrayList arrayList = this.notifications;
        synchronized (arrayList) {
            try {
                this.notifications.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Date timeOffset(long offset) {
        return new Date(System.currentTimeMillis() + offset);
    }

    private void sleep() {
        this.sleep(100L);
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

