/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.server;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.relation.RelationService;
import junit.framework.TestCase;
import test.compliance.server.support.Broadcaster;
import test.compliance.server.support.Test;

public class DefaultDomainTestCase
extends TestCase {
    public DefaultDomainTestCase(String s) {
        super(s);
    }

    public void testDefaultDomainRegisterUnqualified() {
        MBeanServer server = null;
        ObjectName unqualifiedName = null;
        ObjectName qualifiedName = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            unqualifiedName = new ObjectName(":property=1");
            qualifiedName = new ObjectName("DefaultDomain:property=1");
            server.registerMBean(new Test(), unqualifiedName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        DefaultDomainTestCase.assertEquals((String)"DefaultDomain", (String)server.getDefaultDomain());
        try {
            server.getObjectInstance(unqualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Unqualified lookup failed");
        }
        try {
            server.getObjectInstance(qualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Qualified lookup failed");
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testDefaultDomainRegisterQualified() {
        MBeanServer server = null;
        ObjectName unqualifiedName = null;
        ObjectName qualifiedName = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            unqualifiedName = new ObjectName(":property=1");
            qualifiedName = new ObjectName("DefaultDomain:property=1");
            server.registerMBean(new Test(), qualifiedName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        DefaultDomainTestCase.assertEquals((String)"DefaultDomain", (String)server.getDefaultDomain());
        try {
            server.getObjectInstance(unqualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Unqualified lookup failed");
        }
        try {
            server.getObjectInstance(qualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Qualified lookup failed");
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testMyDefaultDomainRegisterUnqualified() {
        MBeanServer server = null;
        ObjectName unqualifiedName = null;
        ObjectName qualifiedName = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            unqualifiedName = new ObjectName(":property=1");
            qualifiedName = new ObjectName("MyDomain:property=1");
            server.registerMBean(new Test(), unqualifiedName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        DefaultDomainTestCase.assertEquals((String)"MyDomain", (String)server.getDefaultDomain());
        try {
            server.getObjectInstance(unqualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Unqualified lookup failed");
        }
        try {
            server.getObjectInstance(qualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Qualified lookup failed");
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testMyDefaultDomainRegisterQualified() {
        MBeanServer server = null;
        ObjectName unqualifiedName = null;
        ObjectName qualifiedName = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            unqualifiedName = new ObjectName(":property=1");
            qualifiedName = new ObjectName("MyDomain:property=1");
            server.registerMBean(new Test(), qualifiedName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        DefaultDomainTestCase.assertEquals((String)"MyDomain", (String)server.getDefaultDomain());
        try {
            server.getObjectInstance(unqualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Unqualified lookup failed");
        }
        try {
            server.getObjectInstance(qualifiedName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"Qualified lookup failed");
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testRegisterQualifiedUnqualified() {
        this.duplicateRegister(":property=1", "MyDomain:property=1");
    }

    public void testRegisterUnqualifiedQualified() {
        this.duplicateRegister("MyDomain:property=1", ":property=1");
    }

    public void testRegisterUnqualifiedUnqualified() {
        this.duplicateRegister(":property=1", ":property=1");
    }

    public void testInvokeQualifiedUnqualified() {
        this.invoke(":property=1", "MyDomain:property=1");
    }

    public void testInvokeUnqualifiedQualified() {
        this.invoke("MyDomain:property=1", ":property=1");
    }

    public void testInvokeUnqualifiedUnqualified() {
        this.invoke(":property=1", ":property=1");
    }

    public void testRegisterQualifiedUnregisterUnqualified() {
        this.unregister("MyDomain:property=1", ":property=1");
    }

    public void testRegisterUnQualifiedUnregisterQualified() {
        this.unregister(":property=1", "MyDomain:property=1");
    }

    public void testRegisterUnqualifiedUnregisterUnqualified() {
        this.unregister(":property=1", ":property=1");
    }

    public void testAddNLUnqualifiedNameListenerRegisterQualified() {
        this.addNLNameListener("MyDomain:property=1", ":property=1");
    }

    public void testAddNLQualifiedNameListenerRegisterUnqualified() {
        this.addNLNameListener(":property=1", "MyDomain:property=1");
    }

    public void testAddNLUnqualifiedNameListenerRegisterUnqualified() {
        this.addNLNameListener(":property=1", ":property=1");
    }

    public void testAddNLUnqualifiedQualifiedRegisterUnqualifiedQualified() {
        this.addNLNameName(":property=1", "MyDomain:property=2", ":property=1", "MyDomain:property=2");
    }

    public void testAddNLUnqualifiedQualifiedRegisterQualifiedQualified() {
        this.addNLNameName(":property=1", "MyDomain:property=2", "MyDomain:property=1", "MyDomain:property=2");
    }

    public void testAddNLQualifiedQualifiedRegisterUnqualifiedQualified() {
        this.addNLNameName("MyDomain:property=1", "MyDomain:property=2", ":property=1", "MyDomain:property=2");
    }

    public void testAddNLQualifiedUnqualifiedRegisterQualifiedUnqualified() {
        this.addNLNameName("MyDomain:property=1", ":property=2", "MyDomain:property=1", ":property=2");
    }

    public void testAddNLQualifiedUnqualifiedRegisterQualifiedQualified() {
        this.addNLNameName("MyDomain:property=1", ":property=2", "MyDomain:property=1", "MyDomain:property=2");
    }

    public void testAddNLQualifiedQualifiedRegisterQualifiedUnqualified() {
        this.addNLNameName("MyDomain:property=1", "MyDomain:property=2", "MyDomain:property=1", ":property=2");
    }

    private void duplicateRegister(String register, String test) {
        MBeanServer server = null;
        ObjectName registerName = null;
        ObjectName testName = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            registerName = new ObjectName(register);
            testName = new ObjectName(test);
            server.registerMBean(new Test(), registerName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        boolean caught = false;
        try {
            server.registerMBean(new Test(), testName);
        }
        catch (InstanceAlreadyExistsException e) {
            caught = true;
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        if (!caught) {
            DefaultDomainTestCase.fail((String)"Allows duplicate registration");
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    private void unregister(String register, String test) {
        MBeanServer server = null;
        ObjectName registerName = null;
        ObjectName testName = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            registerName = new ObjectName(register);
            testName = new ObjectName(test);
            server.registerMBean(new Test(), registerName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        try {
            server.unregisterMBean(testName);
        }
        catch (InstanceNotFoundException e) {
            DefaultDomainTestCase.fail((String)"FAILS IN RI: unregisterMBean doesn't add the default domain");
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    private void addNLNameListener(String register, String test) {
        MBeanServer server = null;
        ObjectName registerName = null;
        ObjectName testName = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            registerName = new ObjectName(register);
            testName = new ObjectName(test);
            server.registerMBean(new Broadcaster(), registerName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        try {
            server.addNotificationListener(testName, new RelationService(true), null, null);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    private void addNLNameName(String register1, String register2, String test1, String test2) {
        MBeanServer server = null;
        ObjectName register1Name = null;
        ObjectName register2Name = null;
        ObjectName test1Name = null;
        ObjectName test2Name = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            register1Name = new ObjectName(register1);
            register2Name = new ObjectName(register2);
            test1Name = new ObjectName(test1);
            test2Name = new ObjectName(test2);
            server.registerMBean(new Broadcaster(), register1Name);
            server.registerMBean(new RelationService(true), register2Name);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        try {
            server.addNotificationListener(test1Name, test2Name, null, null);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    private void invoke(String register, String test) {
        MBeanServer server = null;
        ObjectName registerName = null;
        ObjectName testName = null;
        try {
            server = MBeanServerFactory.createMBeanServer("MyDomain");
            registerName = new ObjectName(register);
            testName = new ObjectName(test);
            server.registerMBean(new Broadcaster(), registerName);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        try {
            server.invoke(testName, "doSomething", new Object[0], new String[0]);
        }
        catch (Exception e) {
            DefaultDomainTestCase.fail((String)e.toString());
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }
}

