/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.relation.Role;
import junit.framework.TestCase;

public class RoleTestCase
extends TestCase {
    public RoleTestCase(String s) {
        super(s);
    }

    public void testBasic() {
        try {
            ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue.add(a);
            roleValue.add(b);
            Role role = new Role("RoleName", roleValue);
            RoleTestCase.assertEquals((String)"RoleName", (String)role.getRoleName());
            RoleTestCase.assertEquals(roleValue, role.getRoleValue());
            role.setRoleName("Changed");
            RoleTestCase.assertEquals((String)"Changed", (String)role.getRoleName());
            ArrayList<ObjectName> roleValue2 = new ArrayList<ObjectName>();
            ObjectName c = new ObjectName(":c=c");
            ObjectName d = new ObjectName(":d=d");
            roleValue2.add(c);
            roleValue2.add(d);
            role.setRoleValue(roleValue2);
            RoleTestCase.assertEquals(roleValue2, role.getRoleValue());
        }
        catch (MalformedObjectNameException mfone) {
            RoleTestCase.fail((String)mfone.toString());
        }
    }

    public void testToString() {
        try {
            ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue.add(a);
            roleValue.add(b);
            Role role = new Role("XYZZY", roleValue);
            String result = Role.roleValueToString(roleValue);
            if (result.lastIndexOf(":a=a") == -1) {
                RoleTestCase.fail((String)"Missing object name :a=a in roleValueToString");
            }
            if (result.lastIndexOf(":b=b") == -1) {
                RoleTestCase.fail((String)"Missing object name :b=b in roleValueToString");
            }
            if ((result = role.toString()).lastIndexOf("XYZZY") == -1) {
                RoleTestCase.fail((String)"Missing role name in toString");
            }
            if (result.lastIndexOf(":a=a") == -1) {
                RoleTestCase.fail((String)"Missing object name :a=a in toString");
            }
            if (result.lastIndexOf(":b=b") == -1) {
                RoleTestCase.fail((String)"Missing object name :b=b in toString");
            }
        }
        catch (MalformedObjectNameException mfone) {
            RoleTestCase.fail((String)mfone.toString());
        }
    }

    public void testErrorHandling() {
        try {
            ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue.add(a);
            roleValue.add(b);
            boolean caught = false;
            try {
                new Role(null, roleValue);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleTestCase.fail((String)"Constructor accepts null role name");
            }
            caught = false;
            try {
                new Role("RoleName", null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleTestCase.fail((String)"Constructor accepts null role value");
            }
            Role role = new Role("RoleName", roleValue);
            caught = false;
            try {
                role.setRoleName(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleTestCase.fail((String)"setRoleName accepts null");
            }
            caught = false;
            try {
                role.setRoleValue(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleTestCase.fail((String)"setRoleValue accepts null");
            }
            caught = false;
            try {
                Role.roleValueToString(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleTestCase.fail((String)"roleValueToString accepts null");
            }
        }
        catch (MalformedObjectNameException mfone) {
            RoleTestCase.fail((String)mfone.toString());
        }
    }

    public void testClone() {
        ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
        try {
            roleValue.add(new ObjectName(":a=a"));
            roleValue.add(new ObjectName(":b=b"));
        }
        catch (MalformedObjectNameException mfone) {
            RoleTestCase.fail((String)mfone.toString());
        }
        Role role = new Role("RoleName", roleValue);
        Role role2 = (Role)role.clone();
        RoleTestCase.assertEquals((String)role.getRoleName(), (String)role2.getRoleName());
        RoleTestCase.assertEquals(role.getRoleValue(), role2.getRoleValue());
        if (role.getRoleValue() == role2.getRoleValue()) {
            RoleTestCase.fail((String)"Role.clone() didn't clone");
        }
    }

    public void testSerialization() {
        ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
        try {
            roleValue.add(new ObjectName(":a=a"));
            roleValue.add(new ObjectName(":b=b"));
        }
        catch (MalformedObjectNameException mfone) {
            RoleTestCase.fail((String)mfone.toString());
        }
        Role role = new Role("RoleName", roleValue);
        Role role2 = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(role);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            role2 = (Role)ois.readObject();
        }
        catch (IOException ioe) {
            RoleTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            RoleTestCase.fail((String)cnfe.toString());
        }
        RoleTestCase.assertEquals((String)role.getRoleName(), (String)role2.getRoleName());
        RoleTestCase.assertEquals(role.getRoleValue(), role2.getRoleValue());
    }
}

