/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationService;
import javax.management.relation.RelationSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleList;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;
import junit.framework.Assert;
import junit.framework.TestCase;

public class RelationSupportTestCase
extends TestCase {
    HashMap services = new HashMap();
    RoleList rolesA;
    HashMap roleInfosA = new HashMap();
    RoleList rolesB;
    HashMap roleInfosB = new HashMap();
    Role roleC1;
    Role roleC2;
    RoleList rolesC;
    HashMap roleInfosC = new HashMap();
    Role roleCX1;
    Role roleCX2;
    RoleList rolesCX;
    HashMap roleInfosCX = new HashMap();
    static /* synthetic */ Class class$test$compliance$relation$support$Trivial;

    public RelationSupportTestCase(String s) {
        super(s);
    }

    public void testDelegateConstructor() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", null);
        this.createRolesB(null);
        RelationSupport support = null;
        try {
            support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RelationSupportTestCase.assertEquals((String)"id", (String)support.getRelationId());
        RelationSupportTestCase.assertEquals((String)"relationTypeB", (String)support.getRelationTypeName());
        RelationSupportTestCase.assertEquals((String)"test:type=service", (String)support.getRelationServiceName().toString());
        RoleList roleList = support.retrieveAllRoles();
        this.compare(this.rolesB, roleList);
    }

    public void testGetAllRoles() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", server);
        this.createRelationTypeB(service);
        this.createRolesB(server);
        RoleResult result = null;
        try {
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getAllRoles();
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.checkResult(result, this.roleInfosB, this.rolesB);
    }

    public void testGetReferencedMBeansNotRegistered() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", null);
        this.createRelationTypeC(service);
        this.createRolesC(server);
        Map<ObjectName, List<String>> result = null;
        try {
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            result = support.getReferencedMBeans();
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.checkMBeans(result, this.rolesC);
    }

    public void testGetReferencedMBeansWhenRegistered() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", server);
        this.createRelationTypeC(service);
        this.createRolesC(server);
        Map<ObjectName, List<String>> result = null;
        try {
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getReferencedMBeans();
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.checkMBeans(result, this.rolesC);
    }

    public void testGetRole() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", server);
        this.createRelationTypeC(service);
        this.createRolesC(server);
        List<ObjectName> result = null;
        try {
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getRole("roleC1");
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.compareListOfObjectNames(this.getRole(this.rolesC, "roleC1").getRoleValue(), result);
    }

    public void testGetRoleCardinalityUnregistered() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", null);
        this.createRolesC(null);
        Integer result = null;
        RelationSupport support = null;
        try {
            support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            result = support.getRoleCardinality("roleC1");
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RelationSupportTestCase.assertEquals((int)2, (int)result);
        try {
            result = support.getRoleCardinality("roleC2");
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RelationSupportTestCase.assertEquals((int)3, (int)result);
    }

    public void testGetRoleCardinalityRegistered() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", server);
        this.createRelationTypeC(service);
        this.createRolesC(server);
        Integer result = null;
        RelationSupport support = null;
        try {
            support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getRoleCardinality("roleC1");
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RelationSupportTestCase.assertEquals((int)2, (int)result);
        try {
            result = support.getRoleCardinality("roleC2");
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RelationSupportTestCase.assertEquals((int)3, (int)result);
    }

    public void testGetRoles() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", server);
        this.createRelationTypeC(service);
        this.createRolesC(server);
        RoleResult result = null;
        RelationSupport support = null;
        try {
            support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getRoles(new String[]{"roleC1", "roleC2"});
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.checkResult(result, this.roleInfosC, this.rolesC);
        try {
            result = support.getRoles(new String[]{"roleC1"});
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RoleList resolved = result.getRoles();
        RelationSupportTestCase.assertEquals((int)1, (int)resolved.size());
        RelationSupportTestCase.assertEquals((int)0, (int)result.getRolesUnresolved().size());
        this.compare(this.getRole(this.rolesC, "roleC1"), (Role)resolved.get(0));
        try {
            result = support.getRoles(new String[]{"roleC2"});
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RoleUnresolvedList unresolved = result.getRolesUnresolved();
        RelationSupportTestCase.assertEquals((int)0, (int)result.getRoles().size());
        RelationSupportTestCase.assertEquals((int)1, (int)unresolved.size());
        RelationSupportTestCase.assertEquals((String)"roleC2", (String)((RoleUnresolved)unresolved.get(0)).getRoleName());
    }

    public void testRelationServiceFlag() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", null);
        this.createRolesB(null);
        RelationSupport support = null;
        try {
            support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        RelationSupportTestCase.assertEquals((boolean)false, (boolean)support.isInRelationService());
        support.setRelationServiceManagementFlag(new Boolean(true));
        RelationSupportTestCase.assertEquals((boolean)true, (boolean)support.isInRelationService());
        support.setRelationServiceManagementFlag(new Boolean(false));
        RelationSupportTestCase.assertEquals((boolean)false, (boolean)support.isInRelationService());
    }

    public void testRetrieveAllRolesUnRegistered() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", null);
        this.createRolesB(null);
        RoleList result = null;
        try {
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            result = support.retrieveAllRoles();
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.compare(this.rolesB, result);
    }

    public void testRetrieveAllRolesRegistered() {
        MBeanServer server = this.createMBeanServer();
        ObjectName service = this.createRelationService("test:type=service", server);
        this.createRelationTypeB(service);
        this.createRolesB(server);
        RoleList result = null;
        try {
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            this.addRelation(server, service, support, "test:type=support");
            result = support.retrieveAllRoles();
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        this.compare(this.rolesB, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRole() {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCX(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.update.mbean");
            try {
                support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
                this.addRelation(server, service, support, "test:type=support1");
                server.addNotificationListener(service, listener, null, null);
                support.setRole(this.roleCX2);
                on = new ObjectName("test:type=support1");
            }
            catch (Exception e) {
                RelationSupportTestCase.fail((String)e.toString());
            }
            RoleList shouldBe = new RoleList();
            shouldBe.add(this.roleC1);
            shouldBe.add(this.roleCX2);
            this.compare(shouldBe, support.retrieveAllRoles());
            RelationNotification rn = listener.check(1);
            RelationSupportTestCase.assertEquals(new ArrayList(), rn.getMBeansToUnregister());
            RelationSupportTestCase.assertEquals(this.roleCX2.getRoleValue(), rn.getNewRoleValue());
            RelationSupportTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationSupportTestCase.assertEquals(this.roleC2.getRoleValue(), rn.getOldRoleValue());
            RelationSupportTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationSupportTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
            RelationSupportTestCase.assertEquals((String)"roleC2", (String)rn.getRoleName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRoles() {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCX(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.update.mbean");
            RoleList shouldBe = new RoleList();
            shouldBe.add(this.roleC1);
            shouldBe.add(this.roleCX2);
            try {
                support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
                this.addRelation(server, service, support, "test:type=support1");
                server.addNotificationListener(service, listener, null, null);
                support.setRoles(shouldBe);
                on = new ObjectName("test:type=support1");
            }
            catch (Exception e) {
                RelationSupportTestCase.fail((String)e.toString());
            }
            this.compare(shouldBe, support.retrieveAllRoles());
            RelationNotification rn = listener.check(1);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testErrors() {
    }

    private MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer();
    }

    private ObjectName createRelationService(String name, MBeanServer server) {
        ObjectName result = null;
        RelationService relationService = new RelationService(true);
        try {
            result = new ObjectName(name);
            this.services.put(result, relationService);
            if (server != null) {
                server.registerMBean(relationService, result);
            }
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        return result;
    }

    private ObjectName addRelation(MBeanServer server, ObjectName service, RelationSupport support, String name) {
        ObjectName result = null;
        try {
            result = new ObjectName(name);
            server.registerMBean(support, result);
            if (service != null) {
                RelationService relationService = (RelationService)this.services.get(service);
                relationService.addRelation(result);
            }
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        return result;
    }

    private RoleInfo createRoleInfo(String name, Class mbean, boolean read, boolean write, int min, int max) {
        RoleInfo result = null;
        try {
            result = new RoleInfo(name, mbean.getName(), read, write, min, max, "");
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        return result;
    }

    private void createRelationType(ObjectName relationService, String name, RoleInfo[] roleInfos) {
        try {
            RelationService service = (RelationService)this.services.get(relationService);
            service.createRelationType(name, roleInfos);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void compare(RoleList original, RoleList result) {
        RelationSupportTestCase.assertEquals((int)original.size(), (int)result.size());
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            Role originalRole = (Role)iterator.next();
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                Role resultRole = (Role)iterator2.next();
                if (!originalRole.getRoleName().equals(resultRole.getRoleName())) continue;
                this.compare(originalRole, resultRole);
                iterator2.remove();
            }
        }
        RelationSupportTestCase.assertEquals((int)0, (int)result.size());
    }

    private void compare(Role original, Role result) {
        RelationSupportTestCase.assertEquals((String)original.getRoleName(), (String)result.getRoleName());
        this.compareListOfObjectNames(original.getRoleValue(), result.getRoleValue());
    }

    private void compareListOfObjectNames(List original, List result) {
        RelationSupportTestCase.assertEquals((int)original.size(), (int)result.size());
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            ObjectName originalBean = (ObjectName)iterator.next();
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                ObjectName resultBean = (ObjectName)iterator2.next();
                if (!originalBean.equals(resultBean)) continue;
                iterator2.remove();
            }
        }
        RelationSupportTestCase.assertEquals((int)0, (int)result.size());
    }

    private void compareListOfStrings(List original, List result) {
        RelationSupportTestCase.assertEquals((int)original.size(), (int)result.size());
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            String originalString = (String)iterator.next();
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                String resultString = (String)iterator2.next();
                if (!originalString.equals(resultString)) continue;
                iterator2.remove();
            }
        }
        RelationSupportTestCase.assertEquals((int)0, (int)result.size());
    }

    private ObjectName createRoleValueBean(String name, Class mbean, MBeanServer server) {
        ObjectName result = null;
        try {
            result = new ObjectName(name);
            if (server != null) {
                server.registerMBean(mbean.newInstance(), result);
            }
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
        return result;
    }

    private void checkResult(RoleResult result, HashMap infos, RoleList roles) {
        this.checkResolved(result.getRoles(), infos, roles);
        this.checkUnresolved(result.getRolesUnresolved(), infos, roles);
    }

    private void checkResolved(RoleList resolved, HashMap infos, RoleList roles) {
        RoleInfo info;
        String roleName;
        Role role;
        RoleList copy = (RoleList)roles.clone();
        Iterator iterator = resolved.iterator();
        while (iterator.hasNext()) {
            role = (Role)iterator.next();
            roleName = role.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (info == null) {
                RelationSupportTestCase.fail((String)("unknown role " + roleName));
            }
            if (!info.isReadable()) {
                RelationSupportTestCase.fail((String)("role should not be readable " + roleName));
            }
            Role original = this.removeRole(copy, roleName);
            this.compareListOfObjectNames(original.getRoleValue(), role.getRoleValue());
        }
        iterator = copy.iterator();
        while (iterator.hasNext()) {
            role = (Role)iterator.next();
            roleName = role.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (!info.isReadable()) continue;
            RelationSupportTestCase.fail((String)("missing role " + roleName));
        }
    }

    private void checkUnresolved(RoleUnresolvedList unresolved, HashMap infos, RoleList roles) {
        RoleInfo info;
        String roleName;
        RoleList copy = (RoleList)roles.clone();
        Iterator iterator = unresolved.iterator();
        while (iterator.hasNext()) {
            RoleUnresolved roleUnresolved = (RoleUnresolved)iterator.next();
            roleName = roleUnresolved.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (info == null) {
                RelationSupportTestCase.fail((String)("unknown role " + roleName));
            }
            if (info.isReadable()) {
                RelationSupportTestCase.fail((String)("role should be readable " + roleName));
            }
            this.removeRole(copy, roleName);
        }
        iterator = copy.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            roleName = role.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (info.isReadable()) continue;
            RelationSupportTestCase.fail((String)("missing unresolved role " + roleName));
        }
    }

    private Role removeRole(RoleList roles, String roleName) {
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.getRoleName().equals(roleName)) continue;
            iterator.remove();
            return role;
        }
        RelationSupportTestCase.fail((String)("role was not in the original " + roleName));
        return null;
    }

    private Role getRole(RoleList roles, String roleName) {
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.getRoleName().equals(roleName)) continue;
            return role;
        }
        RelationSupportTestCase.fail((String)("role was not in the original " + roleName));
        return null;
    }

    private void checkMBeans(Map result, RoleList roles) {
        Map expected = this.calcMBeanRoleMap(roles);
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ObjectName key = (ObjectName)entry.getKey();
            ArrayList roleNames = (ArrayList)entry.getValue();
            ArrayList expectedNames = (ArrayList)expected.get(key);
            if (expectedNames == null) {
                RelationSupportTestCase.fail((String)("Unexpected object name " + key));
            }
            this.compareListOfStrings(expectedNames, roleNames);
            expected.remove(key);
        }
        RelationSupportTestCase.assertEquals((int)0, (int)expected.size());
    }

    private Map calcMBeanRoleMap(RoleList roles) {
        HashMap<ObjectName, ArrayList<String>> result = new HashMap<ObjectName, ArrayList<String>>();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            String roleName = role.getRoleName();
            ArrayList mbeans = (ArrayList)role.getRoleValue();
            Iterator iterator2 = mbeans.iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName = (ObjectName)iterator2.next();
                ArrayList<String> names = (ArrayList<String>)result.get(objectName);
                if (names == null) {
                    names = new ArrayList<String>();
                    result.put(objectName, names);
                }
                names.add(roleName);
            }
        }
        return result;
    }

    private void createRolesA(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleA1Values = new ArrayList<ObjectName>();
            roleA1Values.add(this.createRoleValueBean("x:relation=a,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            Role roleA1 = new Role("roleA1", roleA1Values);
            this.rolesA = new RoleList();
            this.rolesA.add(roleA1);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeA(ObjectName relationService) {
        try {
            RoleInfo roleInfoA1 = this.createRoleInfo("roleA1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, true, 1, 1);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoA1};
            this.createRelationType(relationService, "relationTypeA", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosA.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void createRolesB(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleB1Values = new ArrayList<ObjectName>();
            roleB1Values.add(this.createRoleValueBean("x:relation=b,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleB1Values.add(this.createRoleValueBean("x:relation=b,role=1,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            Role roleB1 = new Role("roleB1", roleB1Values);
            ArrayList<ObjectName> roleB2Values = new ArrayList<ObjectName>();
            roleB2Values.add(this.createRoleValueBean("x:relation=b,role=2,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleB2Values.add(this.createRoleValueBean("x:relation=b,role=2,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleB2Values.add(this.createRoleValueBean("x:relation=b,role=2,bean=3", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            Role roleB2 = new Role("roleB2", roleB2Values);
            this.rolesB = new RoleList();
            this.rolesB.add(roleB1);
            this.rolesB.add(roleB2);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeB(ObjectName relationService) {
        try {
            RoleInfo roleInfoB1 = this.createRoleInfo("roleB1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, false, 1, 2);
            RoleInfo roleInfoB2 = this.createRoleInfo("roleB2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, false, true, 3, 4);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoB1, roleInfoB2};
            this.createRelationType(relationService, "relationTypeB", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosB.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void createRolesC(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleC1Values = new ArrayList<ObjectName>();
            roleC1Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleC1Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            this.roleC1 = new Role("roleC1", roleC1Values);
            ArrayList<ObjectName> roleC2Values = new ArrayList<ObjectName>();
            roleC2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleC2Values.add(this.createRoleValueBean("x:relation=c,role=2,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleC2Values.add(this.createRoleValueBean("x:relation=c,role=2,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleC2 = new Role("roleC2", roleC2Values);
            this.rolesC = new RoleList();
            this.rolesC.add(this.roleC1);
            this.rolesC.add(this.roleC2);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeC(ObjectName relationService) {
        try {
            RoleInfo roleInfoC1 = this.createRoleInfo("roleC1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, false, 1, 2);
            RoleInfo roleInfoC2 = this.createRoleInfo("roleC2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, false, true, 3, 4);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoC1, roleInfoC2};
            this.createRelationType(relationService, "relationTypeC", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosC.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    private void createRolesCX(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleCX1Values = new ArrayList<ObjectName>();
            roleCX1Values.add(this.createRoleValueBean("x:relation=c,role=2,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            this.roleCX1 = new Role("roleC1", roleCX1Values);
            ArrayList<ObjectName> roleCX2Values = new ArrayList<ObjectName>();
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=3", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=4", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationSupportTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleCX2 = new Role("roleC2", roleCX2Values);
            this.rolesCX = new RoleList();
            this.rolesCX.add(this.roleCX1);
            this.rolesCX.add(this.roleCX2);
        }
        catch (Exception e) {
            RelationSupportTestCase.fail((String)e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener
    implements NotificationListener {
        String type;
        HashSet notifications = new HashSet();

        public Listener(String type) {
            this.type = type;
        }

        public void handleNotification(Notification n, Object h) {
            this.notifications.add(n);
        }

        public RelationNotification check(int size) {
            RelationNotification result = null;
            Assert.assertEquals((int)size, (int)this.notifications.size());
            Iterator iterator = this.notifications.iterator();
            while (iterator.hasNext()) {
                RelationNotification rn = (RelationNotification)iterator.next();
                Assert.assertEquals((String)this.type, (String)rn.getType());
                result = rn;
            }
            return result;
        }
    }
}

