/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import junit.framework.TestCase;

public class TabularTypeTestCase
extends TestCase {
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;
    static /* synthetic */ Class class$javax$management$openmbean$TabularType;

    public TabularTypeTestCase(String s) {
        super(s);
    }

    public void testTabularTypeOpenType() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularTypeTestCase.assertEquals((String)(class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = TabularTypeTestCase.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName(), (String)tabularType.getClassName());
        TabularTypeTestCase.assertEquals((String)"description", (String)tabularType.getDescription());
        TabularTypeTestCase.assertEquals((String)"typeName", (String)tabularType.getTypeName());
        TabularTypeTestCase.assertTrue((String)"Tabular type should not be an array", (!tabularType.isArray() ? 1 : 0) != 0);
    }

    public void testGetRowType() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularTypeTestCase.assertEquals((Object)rowType, (Object)tabularType.getRowType());
    }

    public void testIndexNames() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        List<String> indexList = tabularType.getIndexNames();
        TabularTypeTestCase.assertTrue((String)"wrong number of index names", (indexList.size() == 2 ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"index list should contain name1", (boolean)indexList.contains("name1"));
        TabularTypeTestCase.assertTrue((String)"index list should contain name2", (boolean)indexList.contains("name2"));
        Iterator<String> i = indexList.iterator();
        TabularTypeTestCase.assertTrue((String)"first index is name1", (boolean)i.next().equals("name1"));
        TabularTypeTestCase.assertTrue((String)"second index is name2", (boolean)i.next().equals("name2"));
    }

    public void testIsValue() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularTypeTestCase.assertTrue((String)"null is not a value of tabular type", (!tabularType.isValue(null) ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"object is not a value of tabular type", (!tabularType.isValue(new Object()) ? 1 : 0) != 0);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularTypeTestCase.assertTrue((String)"data should is a value", (boolean)tabularType.isValue(data));
        TabularType tabularType2 = new TabularType("typeName", "description", rowType, indexNames);
        data = new TabularDataSupport(tabularType2);
        TabularTypeTestCase.assertTrue((String)"data is a value, even though the tabular type is a different instance", (boolean)tabularType.isValue(data));
        tabularType2 = new TabularType("typeName2", "description", rowType, indexNames);
        data = new TabularDataSupport(tabularType2);
        TabularTypeTestCase.assertTrue((String)"data should not be a value, they have different type names", (!tabularType.isValue(data) ? 1 : 0) != 0);
        CompositeType rowType2 = new CompositeType("rowTypeName2", "rowDescription", itemNames, itemDescriptions, itemTypes);
        tabularType2 = new TabularType("typeName", "description", rowType2, indexNames);
        data = new TabularDataSupport(tabularType2);
        TabularTypeTestCase.assertTrue((String)"data should not be a value, they have different row types", (!tabularType.isValue(data) ? 1 : 0) != 0);
        String[] indexNames2 = new String[]{"name2", "name1"};
        tabularType2 = new TabularType("typeName", "description", rowType, indexNames2);
        data = new TabularDataSupport(tabularType2);
        TabularTypeTestCase.assertTrue((String)"data should not be a value, they have different index names", (!tabularType.isValue(data) ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularTypeTestCase.assertTrue((String)"null is not equal to tabular type", (!tabularType.equals(null) ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"object is not a equal to tabular type", (!tabularType.equals(new Object()) ? 1 : 0) != 0);
        TabularType tabularType2 = new TabularType("typeName", "description", rowType, indexNames);
        TabularTypeTestCase.assertTrue((String)"Should be equal, even though the tabular type is a different instance", (boolean)tabularType.equals(tabularType2));
        TabularTypeTestCase.assertTrue((String)"Should be equal, even though the tabular type is a different instance", (boolean)tabularType2.equals(tabularType));
        tabularType2 = new TabularType("typeName2", "description", rowType, indexNames);
        TabularTypeTestCase.assertTrue((String)"should not be equal, they have different type names", (!tabularType.equals(tabularType2) ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"should not be equal, they have different type names", (!tabularType2.equals(tabularType) ? 1 : 0) != 0);
        CompositeType rowType2 = new CompositeType("rowTypeName2", "rowDescription", itemNames, itemDescriptions, itemTypes);
        tabularType2 = new TabularType("typeName", "description", rowType2, indexNames);
        TabularTypeTestCase.assertTrue((String)"should not be a equal, they have different row types", (!tabularType.equals(tabularType2) ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"should not be a equal, they have different row types", (!tabularType2.equals(tabularType) ? 1 : 0) != 0);
        String[] indexNames2 = new String[]{"name2", "name1"};
        tabularType2 = new TabularType("typeName", "description", rowType, indexNames2);
        TabularTypeTestCase.assertTrue((String)"should not be equal, they have different index names", (!tabularType.equals(tabularType2) ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"should not be equal, they have different index names", (!tabularType2.equals(tabularType) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        int myHashCode = "typeName".hashCode() + rowType.hashCode() + "name1".hashCode() + "name2".hashCode();
        TabularTypeTestCase.assertTrue((String)"Wrong hash code generated", (myHashCode == tabularType.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        String toString = tabularType.toString();
        TabularTypeTestCase.assertTrue((String)"toString() should contain the tabular type class name", (toString.indexOf((class$javax$management$openmbean$TabularType == null ? (class$javax$management$openmbean$TabularType = TabularTypeTestCase.class$("javax.management.openmbean.TabularType")) : class$javax$management$openmbean$TabularType).getName()) != -1 ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"toString() should contain the type name", (toString.indexOf("typeName") != -1 ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)("toString() should contain the row type " + rowType), (toString.indexOf(rowType.toString()) != -1 ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"toString() should contain the index name1", (toString.indexOf("name1") != -1 ? 1 : 0) != 0);
        TabularTypeTestCase.assertTrue((String)"toString() should contain the index name2", (toString.indexOf("name2") != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(tabularType);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        TabularTypeTestCase.assertEquals((Object)tabularType, (Object)result);
    }

    public void testErrors() throws Exception {
        TabularType tabularType;
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        boolean caught = false;
        try {
            tabularType = new TabularType(null, "description", rowType, indexNames);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for null type name");
        }
        caught = false;
        try {
            tabularType = new TabularType("", "description", rowType, indexNames);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for empty type name");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", null, rowType, indexNames);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "", rowType, indexNames);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for empty description");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "description", null, indexNames);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for null row type");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "description", rowType, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for null index names");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "description", rowType, new String[0]);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for empty index names");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "description", rowType, new String[]{"name1", null});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for null index name element");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "description", rowType, new String[]{"name1", ""});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected IllegalArgumentException for empty index name element");
        }
        caught = false;
        try {
            tabularType = new TabularType("typeName", "description", rowType, new String[]{"name1", "nameX"});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            TabularTypeTestCase.fail((String)"Expected OpenDataException for invalid index name");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

