/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import junit.framework.TestCase;

public class OpenMBeanParameterInfoSupportTestCase
extends TestCase {
    public OpenMBeanParameterInfoSupportTestCase(String s) {
        super(s);
    }

    public void testOpenMBeanParameterInfoSupport() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, "default");
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)"default", (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasDefaultValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasDefaultValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(2), new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), null, new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(4), info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(2), null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(2), info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), null, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)new Integer(3), (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.Integer", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMinValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, "default", new Object[]{"legal1", "legal2", "default"});
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)"default", (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((int)3, (int)info.getLegalValues().size());
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"legal1 should be a legal value", (boolean)info.getLegalValues().contains("legal1"));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"legal2 should be a legal value", (boolean)info.getLegalValues().contains("legal2"));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"default should be a legal value", (boolean)info.getLegalValues().contains("default"));
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, null, new Object[]{"legal1", "legal2", "default"});
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((int)3, (int)info.getLegalValues().size());
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"legal1 should be a legal value", (boolean)info.getLegalValues().contains("legal1"));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"legal2 should be a legal value", (boolean)info.getLegalValues().contains("legal2"));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"default should be a legal value", (boolean)info.getLegalValues().contains("default"));
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, "default", null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)"default", (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getLegalValues());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, null, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanParameterInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getType());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, (Object)info.getDefaultValue());
        OpenMBeanParameterInfoSupportTestCase.assertEquals(null, info.getLegalValues());
    }

    public void testOpenType() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertEquals(SimpleType.STRING, info.getOpenType());
    }

    public void testHas() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, "default");
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasDefaultValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasDefaultValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(3), null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasMinValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasMinValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, new Integer(3));
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasMaxValue());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(3)});
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)true, (boolean)info.hasLegalValues());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null);
        OpenMBeanParameterInfoSupportTestCase.assertEquals((boolean)false, (boolean)info.hasLegalValues());
    }

    public void testIsValue() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"String should be a value", (boolean)info.isValue("string"));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Integer should not be a value", (!info.isValue(new Integer(3)) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Null should not be a value", (!info.isValue(null) ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Only OpenMBeanParameterInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupport info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanParameterInfoSupport("name", "description2", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different descriptions are equal", (boolean)info.equals(info2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different descritpions are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanParameterInfoSupport("name2", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(2), new Integer(2), new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(2), null, new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different default values are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same default value are equal", (boolean)info.equals(info2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same default value are equal", (boolean)info2.equals(info));
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(2), null);
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(2), null);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same minimum are equal", (boolean)info.equals(info2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same minimum are equal", (boolean)info2.equals(info));
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, new Integer(2));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null, new Integer(2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same maximum are equal", (boolean)info.equals(info2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same maximum are equal", (boolean)info2.equals(info));
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(1), new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), null, new Integer(4));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different minimums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(5));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), null);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Instances with different maximums are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2), new Integer(3)});
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same legal values are equal", (boolean)info.equals(info2));
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances of the same legal values are equal", (boolean)info2.equals(info));
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2), new Integer(4)});
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2)});
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info2.equals(info) ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Object[]{new Integer(2), new Integer(3)});
        info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, null);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"Different instances with different legal values are equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        int myHash = "name".hashCode() + SimpleType.INTEGER.hashCode() + new Integer(3).hashCode() + new Integer(2).hashCode() + new Integer(4).hashCode();
        OpenMBeanParameterInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Object[]{new Integer(2), new Integer(3), new Integer(4)});
        myHash = "name".hashCode() + SimpleType.INTEGER.hashCode() + new Integer(3).hashCode() + new Integer(2).hashCode() + new Integer(3).hashCode() + new Integer(4).hashCode();
        OpenMBeanParameterInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
    }

    public void testToString() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        String toString = info.toString();
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the name", (toString.indexOf("name") != -1 ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the simple type", (toString.indexOf(SimpleType.INTEGER.toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the default value", (toString.indexOf(new Integer(3).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the minimum value", (toString.indexOf(new Integer(2).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the maximum value", (toString.indexOf(new Integer(4).toString()) != -1 ? 1 : 0) != 0);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Object[]{new Integer(2), new Integer(3), new Integer(4)});
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the legal value 2", (toString.indexOf(new Integer(2).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the legal value 3", (toString.indexOf(new Integer(3).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupportTestCase.assertTrue((String)"info.toString() should contain the legal value 4", (toString.indexOf(new Integer(4).toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        OpenMBeanParameterInfoSupport info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Integer(2), new Integer(4));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)info, (Object)result);
        info = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(3), new Object[]{new Integer(2), new Integer(3), new Integer(4)});
        baos = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        bais = new ByteArrayInputStream(baos.toByteArray());
        ois = new ObjectInputStream(bais);
        result = ois.readObject();
        OpenMBeanParameterInfoSupportTestCase.assertEquals((Object)info, (Object)result);
    }

    public void testErrors1() throws Exception {
        OpenMBeanParameterInfoSupport info;
        boolean caught = false;
        try {
            info = new OpenMBeanParameterInfoSupport(null, "description", SimpleType.INTEGER);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            info = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info = new OpenMBeanParameterInfoSupport("name", null, SimpleType.INTEGER);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            info = new OpenMBeanParameterInfoSupport("name", "", SimpleType.INTEGER);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            info = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info = new OpenMBeanParameterInfoSupport("name", "description", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
    }

    public void testErrors2() throws Exception {
        TabularType tabularType;
        String[] indexNames;
        CompositeType rowType;
        OpenType[] itemTypes;
        String[] itemDescriptions;
        String[] itemNames;
        OpenMBeanParameterInfoSupport info;
        ArrayType arrayType;
        OpenMBeanParameterInfoSupport info2;
        boolean caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport(null, "description", SimpleType.INTEGER, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", null, SimpleType.INTEGER, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "", SimpleType.INTEGER, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", null, new Integer(3));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, new Integer(3));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for wrong simple type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info = new OpenMBeanParameterInfoSupport("name", "description", arrayType, new String[0]);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info = new OpenMBeanParameterInfoSupport("name", "description", arrayType, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't execpt OpenDataException for array type and no default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            OpenMBeanParameterInfoSupport info3 = new OpenMBeanParameterInfoSupport("name", "description", tabularType, data);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            OpenMBeanParameterInfoSupport info4 = new OpenMBeanParameterInfoSupport("name", "description", tabularType, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't execpt OpenDataException for tabular type and null default value");
        }
    }

    public void testErrors3() throws Exception {
        OpenMBeanParameterInfoSupport info;
        OpenMBeanParameterInfoSupport info2;
        TabularDataSupport data;
        TabularType tabularType;
        String[] indexNames;
        CompositeType rowType;
        OpenType[] itemTypes;
        String[] itemDescriptions;
        String[] itemNames;
        OpenMBeanParameterInfoSupport info3;
        ArrayType arrayType;
        OpenMBeanParameterInfoSupport info4;
        boolean caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport(null, "description", SimpleType.INTEGER, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("name", null, SimpleType.INTEGER, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("name", "", SimpleType.INTEGER, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("name", "description", null, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, new Integer(3), new Integer[]{new Integer(3), new Integer(4)});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for wrong simple type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info3 = new OpenMBeanParameterInfoSupport("name", "description", arrayType, new String[0], null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info3 = new OpenMBeanParameterInfoSupport("name", "description", arrayType, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for array type and no default value and legals");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            data = new TabularDataSupport(tabularType);
            info2 = new OpenMBeanParameterInfoSupport("name", "description", tabularType, data, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            info = new OpenMBeanParameterInfoSupport("name", "description", tabularType, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for tabular type and null default value and legals");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info3 = new OpenMBeanParameterInfoSupport("name", "description", arrayType, null, new String[]{"hello", "goodbye"});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info3 = new OpenMBeanParameterInfoSupport("name", "description", arrayType, null, new String[0]);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for array type and no default value and empty legals");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            data = new TabularDataSupport(tabularType);
            info2 = new OpenMBeanParameterInfoSupport("name", "description", tabularType, null, new TabularDataSupport[]{data});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and legal values");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            info = new OpenMBeanParameterInfoSupport("name", "description", tabularType, null, new TabularDataSupport[0]);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for tabular type and null default value and empty legals");
        }
        caught = false;
        try {
            info4 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, new Integer(3), new Integer[]{new Integer(2), new Integer(4)});
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for default value not a legal value");
        }
    }

    public void testErrors4() throws Exception {
        TabularType tabularType;
        String[] indexNames;
        CompositeType rowType;
        OpenType[] itemTypes;
        String[] itemDescriptions;
        String[] itemNames;
        OpenMBeanParameterInfoSupport info;
        ArrayType arrayType;
        OpenMBeanParameterInfoSupport info2;
        boolean caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport(null, "description", SimpleType.INTEGER, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", null, SimpleType.INTEGER, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "", SimpleType.INTEGER, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty description");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("", "description", SimpleType.INTEGER, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", null, new Integer(3), new Integer(3), new Integer(4));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null simple type");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, new Integer(3), null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for wrong simple type and default value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, null, new Integer(3), null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for wrong simple type and minimum value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, null, null, new Integer(3));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for wrong simple type and maximum value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info = new OpenMBeanParameterInfoSupport("name", "description", arrayType, new String[0], null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            info = new OpenMBeanParameterInfoSupport("name", "description", arrayType, null, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for array type and no default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            OpenMBeanParameterInfoSupport info3 = new OpenMBeanParameterInfoSupport("name", "description", tabularType, data, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for tabular type and default value");
        }
        caught = false;
        try {
            itemNames = new String[]{"name1", "name2"};
            itemDescriptions = new String[]{"desc1", "desc2"};
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
            rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
            indexNames = new String[]{"name1", "name2"};
            tabularType = new TabularType("typeName", "description", rowType, indexNames);
            OpenMBeanParameterInfoSupport info4 = new OpenMBeanParameterInfoSupport("name", "description", tabularType, null, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for tabular type and null default value");
        }
        caught = false;
        try {
            arrayType = new ArrayType(1, SimpleType.STRING);
            OpenMBeanParameterInfoSupport openMBeanParameterInfoSupport = new OpenMBeanParameterInfoSupport("name", "description", arrayType, new String[]{"hello", "goodbye"}, null, null);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for array type and default value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING, new Integer(3), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for default value less than minimum value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(4), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for default value equal minimum value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(6), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for default value greater than maximum value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, new Integer(5), new Integer(4), new Integer(5));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for default value equal maximum value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(4), new Integer(3));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Expected OpenDataException for minimum greater than maximum value");
        }
        caught = false;
        try {
            info2 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.INTEGER, null, new Integer(4), new Integer(4));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanParameterInfoSupportTestCase.fail((String)"Didn't expect OpenDataException for minimum equal maximum value");
        }
    }
}

