/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Set;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import junit.framework.TestCase;

public class OpenMBeanOperationInfoSupportTestCase
extends TestCase {
    public OpenMBeanOperationInfoSupportTestCase(String s) {
        super(s);
    }

    public void testOpenMBeanOperationInfoSupport() throws Exception {
        OpenMBeanOperationInfoSupport info = new OpenMBeanOperationInfoSupport("name", "description", null, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)0, (int)info.getSignature().length);
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getReturnType());
        OpenMBeanOperationInfoSupportTestCase.assertEquals(SimpleType.STRING, info.getReturnOpenType());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)2, (int)info.getImpact());
        info = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[0], SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)0, (int)info.getSignature().length);
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getReturnType());
        OpenMBeanOperationInfoSupportTestCase.assertEquals(SimpleType.STRING, info.getReturnOpenType());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)2, (int)info.getImpact());
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        info = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)1, (int)info.getSignature().length);
        OpenMBeanOperationInfoSupportTestCase.assertEquals((String)"java.lang.String", (String)info.getReturnType());
        OpenMBeanOperationInfoSupportTestCase.assertEquals(SimpleType.STRING, info.getReturnOpenType());
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)2, (int)info.getImpact());
    }

    public void testReturnOpenType() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanOperationInfoSupport info = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.BOOLEAN, 2);
        OpenMBeanOperationInfoSupportTestCase.assertEquals(SimpleType.BOOLEAN, info.getReturnOpenType());
    }

    public void testEquals() throws Exception {
        OpenMBeanOperationInfoSupport info = new OpenMBeanOperationInfoSupport("name", "description", null, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Only OpenMBeanOperationInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupport info2 = new OpenMBeanOperationInfoSupport("name", "description", null, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanOperationInfoSupport("name", "description2", null, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different descriptions are equal", (boolean)info.equals(info2));
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different descritpions are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanOperationInfoSupport("name2", "description", null, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupport param1 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupport param2 = new OpenMBeanParameterInfoSupport("name2", "description", SimpleType.STRING);
        info = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2}, SimpleType.STRING, 2);
        info2 = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2}, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with the same parameters are equal", (boolean)info.equals(info2));
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with the same parameters are equal", (boolean)info2.equals(info));
        info = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2}, SimpleType.STRING, 2);
        info2 = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param2, param1}, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with the same signature but different parameters are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with the same signature but different parameters are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        param2 = new OpenMBeanParameterInfoSupport("name2", "description", SimpleType.INTEGER);
        info2 = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2}, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different signatures are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different signatures are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1}, SimpleType.STRING, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different numbers of paramters are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different numbers of parameters are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2}, SimpleType.INTEGER, 2);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different return types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different return types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanOperationInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2}, SimpleType.STRING, 1);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different impacts are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"Different instances with different impacts are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanOperationInfoSupport info = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2);
        int myHash = "name".hashCode() + ((Object)Arrays.asList(parms)).hashCode() + SimpleType.STRING.hashCode() + 2;
        OpenMBeanOperationInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
    }

    public void testToString() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanOperationInfoSupport info = new OpenMBeanOperationInfoSupport("NAME", "DESCRIPTION", parms, SimpleType.INTEGER, 2);
        String toString = info.toString();
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"info.toString() should contain NAME", (toString.indexOf("NAME") != -1 ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"info.toString() should contain the parameters", (toString.indexOf(Arrays.asList(parms).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanOperationInfoSupportTestCase.assertTrue((String)"info.toString() should contain the simple type", (toString.indexOf(SimpleType.INTEGER.toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanOperationInfoSupport info = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        OpenMBeanOperationInfoSupportTestCase.assertEquals((Object)info, (Object)result);
    }

    public void testErrors() throws Exception {
        OpenMBeanOperationInfoSupport info;
        OpenMBeanParameterInfo[] parms;
        boolean caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport(null, "description", parms, SimpleType.STRING, 2);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport("", "description", parms, SimpleType.STRING, 2);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for empty name");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport("name", null, parms, SimpleType.STRING, 2);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport("name", "", parms, SimpleType.STRING, 2);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for empty description");
        }
        caught = false;
        try {
            OpenMBeanOperationInfoSupport info2 = new OpenMBeanOperationInfoSupport("name", "description", new MyOpenMBeanParameterInfo[]{new MyOpenMBeanParameterInfo()}, SimpleType.STRING, 2);
        }
        catch (ArrayStoreException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected ArrayStoreException for non MBeanParameterInfo array");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport("name", "description", parms, null, 2);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null return type");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.VOID, 2);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Didn't expect IllegalArgumentException for VOID return type");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 1234567);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentExecption for invalid action");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            OpenMBeanOperationInfoSupport openMBeanOperationInfoSupport = new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 3);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanOperationInfoSupportTestCase.fail((String)"Expected IllegalArgumentExecption for UNKNOWN action");
        }
    }

    public static class MyOpenMBeanParameterInfo
    implements OpenMBeanParameterInfo {
        public boolean equals(Object o) {
            return false;
        }

        public Object getDefaultValue() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public Set getLegalValues() {
            return null;
        }

        public Comparable getMaxValue() {
            return null;
        }

        public Comparable getMinValue() {
            return null;
        }

        public String getName() {
            return null;
        }

        public OpenType getOpenType() {
            return null;
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public boolean hasLegalValues() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean hasMaxValue() {
            return false;
        }

        public boolean hasMinValue() {
            return false;
        }

        public boolean isValue(Object o) {
            return false;
        }

        public String toString() {
            return null;
        }
    }
}

