/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Set;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import junit.framework.TestCase;

public class OpenMBeanConstructorInfoSupportTestCase
extends TestCase {
    public OpenMBeanConstructorInfoSupportTestCase(String s) {
        super(s);
    }

    public void testOpenMBeanConstructorInfoSupport() throws Exception {
        OpenMBeanConstructorInfoSupport info = new OpenMBeanConstructorInfoSupport("name", "description", null);
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((int)0, (int)info.getSignature().length);
        info = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[0]);
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((int)0, (int)info.getSignature().length);
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        info = new OpenMBeanConstructorInfoSupport("name", "description", parms);
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((String)"name", (String)info.getName());
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((int)1, (int)info.getSignature().length);
    }

    public void testEquals() throws Exception {
        OpenMBeanConstructorInfoSupport info = new OpenMBeanConstructorInfoSupport("name", "description", null);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Only OpenMBeanConstructorInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupport info2 = new OpenMBeanConstructorInfoSupport("name", "description", null);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanConstructorInfoSupport("name", "description2", null);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with different descriptions are equal", (boolean)info.equals(info2));
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with different descritpions are equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanConstructorInfoSupport("name2", "description", null);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        OpenMBeanParameterInfoSupport param1 = new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING);
        OpenMBeanParameterInfoSupport param2 = new OpenMBeanParameterInfoSupport("name2", "description", SimpleType.STRING);
        info = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2});
        info2 = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2});
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with the same parameters are equal", (boolean)info.equals(info2));
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with the same parameters are equal", (boolean)info2.equals(info));
        info = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2});
        info2 = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param2, param1});
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with the same signature but different parameters are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with the same signature but different parameters are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        param2 = new OpenMBeanParameterInfoSupport("name2", "description", SimpleType.INTEGER);
        info2 = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1, param2});
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with different signatures are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with different signatures are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanConstructorInfoSupport("name", "description", new OpenMBeanParameterInfoSupport[]{param1});
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with different numbers of paramters are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"Different instances with different numbers of parameters are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanConstructorInfoSupport info = new OpenMBeanConstructorInfoSupport("name", "description", parms);
        int myHash = "name".hashCode() + ((Object)Arrays.asList(parms)).hashCode();
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
    }

    public void testToString() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanConstructorInfoSupport info = new OpenMBeanConstructorInfoSupport("NAME", "DESCRIPTION", parms);
        String toString = info.toString();
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"info.toString() should contain NAME", (toString.indexOf("NAME") != -1 ? 1 : 0) != 0);
        OpenMBeanConstructorInfoSupportTestCase.assertTrue((String)"info.toString() should contain the parameters", (toString.indexOf(Arrays.asList(parms).toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanConstructorInfoSupport info = new OpenMBeanConstructorInfoSupport("name", "description", parms);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        OpenMBeanConstructorInfoSupportTestCase.assertEquals((Object)info, (Object)result);
    }

    public void testErrors() throws Exception {
        OpenMBeanConstructorInfoSupport info;
        OpenMBeanParameterInfo[] parms;
        boolean caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanConstructorInfoSupport(null, "description", parms);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanConstructorInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanConstructorInfoSupport("", "description", parms);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanConstructorInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for empty name");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            info = new OpenMBeanConstructorInfoSupport("name", null, parms);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanConstructorInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for null description");
        }
        caught = false;
        try {
            parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
            OpenMBeanConstructorInfoSupport openMBeanConstructorInfoSupport = new OpenMBeanConstructorInfoSupport("name", "", parms);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanConstructorInfoSupportTestCase.fail((String)"Expected IllegalArgumentException for empty description");
        }
        caught = false;
        try {
            OpenMBeanConstructorInfoSupport info2 = new OpenMBeanConstructorInfoSupport("name", "description", new MyOpenMBeanParameterInfo[]{new MyOpenMBeanParameterInfo()});
        }
        catch (ArrayStoreException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanConstructorInfoSupportTestCase.fail((String)"Expected ArrayStoreException for non MBeanParameterInfo array");
        }
    }

    public static class MyOpenMBeanParameterInfo
    implements OpenMBeanParameterInfo {
        public boolean equals(Object o) {
            return false;
        }

        public Object getDefaultValue() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public Set getLegalValues() {
            return null;
        }

        public Comparable getMaxValue() {
            return null;
        }

        public Comparable getMinValue() {
            return null;
        }

        public String getName() {
            return null;
        }

        public OpenType getOpenType() {
            return null;
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public boolean hasLegalValues() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean hasMaxValue() {
            return false;
        }

        public boolean hasMinValue() {
            return false;
        }

        public boolean isValue(Object o) {
            return false;
        }

        public String toString() {
            return null;
        }
    }
}

