/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.security.Principal;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.Transaction;
import org.jboss.iiop.CorbaORB;
import org.jboss.iiop.csiv2.SASCurrent;
import org.jboss.iiop.rmi.RmiIdlUtil;
import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.PayloadKey;
import org.jboss.invocation.iiop.ReferenceData;
import org.jboss.invocation.iiop.ServantWithMBeanServer;
import org.jboss.logging.Logger;
import org.jboss.proxy.ejb.HandleImplIIOP;
import org.jboss.proxy.ejb.LocalIIOPInvoker;
import org.jboss.security.SimplePrincipal;
import org.jboss.tm.iiop.TxServerInterceptor;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.POA;

public class EjbObjectCorbaServant
extends ServantWithMBeanServer
implements InvokeHandler,
LocalIIOPInvoker {
    private final ObjectName containerName;
    private final ClassLoader containerClassLoader;
    private final Current poaCurrent;
    private final Map methodInvokerMap;
    private final String[] repositoryIds;
    private final InterfaceDef interfaceDef;
    private final Logger logger;
    private final boolean traceEnabled;
    private MBeanServer mbeanServer;
    private SASCurrent sasCurrent;

    public EjbObjectCorbaServant(ObjectName containerName, ClassLoader containerClassLoader, Current poaCurrent, Map methodInvokerMap, String[] repositoryIds, InterfaceDef interfaceDef, Logger logger) {
        this.containerName = containerName;
        this.containerClassLoader = containerClassLoader;
        this.poaCurrent = poaCurrent;
        this.methodInvokerMap = methodInvokerMap;
        this.repositoryIds = repositoryIds;
        this.interfaceDef = interfaceDef;
        this.logger = logger;
        this.traceEnabled = logger.isTraceEnabled();
        try {
            this.sasCurrent = (SASCurrent)CorbaORB.getInstance().resolve_initial_references("SASCurrent");
        }
        catch (InvalidName invalidName) {
            this.sasCurrent = null;
        }
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public Object _get_interface_def() {
        if (this.interfaceDef != null) {
            return this.interfaceDef;
        }
        return super._get_interface_def();
    }

    public String[] _all_interfaces(POA poa, byte[] objectId) {
        return (String[])this.repositoryIds.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream in, ResponseHandler handler) {
        if (this.traceEnabled) {
            this.logger.trace((java.lang.Object)("EJBObject invocation: " + opName));
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.containerClassLoader);
        try {
            OutputStream out;
            java.lang.Object id;
            SkeletonStrategy op = (SkeletonStrategy)this.methodInvokerMap.get(opName);
            if (op == null) {
                this.logger.debug((java.lang.Object)("Unable to find opname '" + opName + "' valid operations:" + this.methodInvokerMap.keySet()));
                throw new BAD_OPERATION(opName);
            }
            try {
                id = ReferenceData.extractObjectId(this.poaCurrent.get_object_id());
                if (this.traceEnabled && id != null) {
                    this.logger.trace((java.lang.Object)("                      id class is " + id.getClass().getName()));
                }
            }
            catch (Exception e) {
                this.logger.error((java.lang.Object)"Error getting EJBObject id", (Throwable)e);
                throw new UnknownException((Throwable)e);
            }
            try {
                java.lang.Object retVal;
                if (opName.equals("_get_handle")) {
                    retVal = new HandleImplIIOP(this._this_object());
                } else {
                    Transaction tx = TxServerInterceptor.getCurrentTransaction();
                    SimplePrincipal principal = null;
                    char[] password = null;
                    if (this.sasCurrent != null) {
                        byte[] username = this.sasCurrent.get_incoming_username();
                        byte[] credential = this.sasCurrent.get_incoming_password();
                        String name = new String(username, "UTF-8");
                        int domainIndex = name.indexOf(64);
                        if (domainIndex > 0) {
                            name = name.substring(0, domainIndex);
                        }
                        if (name.length() == 0) {
                            byte[] incomingName = this.sasCurrent.get_incoming_principal_name();
                            if (incomingName.length > 0) {
                                name = new String(incomingName, "UTF-8");
                                domainIndex = name.indexOf(64);
                                if (domainIndex > 0) {
                                    name = name.substring(0, domainIndex);
                                }
                                principal = new SimplePrincipal(name);
                                password = name.toCharArray();
                            }
                        } else {
                            principal = new SimplePrincipal(name);
                            password = new String(credential, "UTF-8").toCharArray();
                        }
                    }
                    java.lang.Object[] params = op.readParams((InputStream)in);
                    Invocation inv = new Invocation(id, op.getMethod(), params, tx, principal, password);
                    inv.setValue((java.lang.Object)InvocationKey.INVOKER_PROXY_BINDING, (java.lang.Object)"iiop", PayloadKey.AS_IS);
                    inv.setType(InvocationType.REMOTE);
                    retVal = this.mbeanServer.invoke(this.containerName, "invoke", new java.lang.Object[]{inv}, Invocation.INVOKE_SIGNATURE);
                }
                out = (OutputStream)handler.createReply();
                if (op.isNonVoid()) {
                    op.writeRetval(out, retVal);
                }
            }
            catch (Exception e) {
                if (this.traceEnabled) {
                    this.logger.trace((java.lang.Object)"Exception in EJBObject invocation", (Throwable)e);
                }
                if (e instanceof MBeanException) {
                    e = ((MBeanException)e).getTargetException();
                }
                RmiIdlUtil.rethrowIfCorbaSystemException(e);
                out = (OutputStream)handler.createExceptionReply();
                op.writeException(out, e);
            }
            OutputStream outputStream = out;
            return outputStream;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public java.lang.Object invoke(String opName, java.lang.Object[] arguments, Transaction tx, Principal identity, java.lang.Object credential) throws Exception {
        if (this.traceEnabled) {
            this.logger.trace((java.lang.Object)("EJBObject local invocation: " + opName));
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.containerClassLoader);
        try {
            java.lang.Object id;
            SkeletonStrategy op = (SkeletonStrategy)this.methodInvokerMap.get(opName);
            if (op == null) {
                throw new BAD_OPERATION(opName);
            }
            try {
                id = ReferenceData.extractObjectId(this.poaCurrent.get_object_id());
                if (this.traceEnabled && id != null) {
                    this.logger.trace((java.lang.Object)("                      id class is " + id.getClass().getName()));
                }
            }
            catch (Exception e) {
                this.logger.error((java.lang.Object)"Error getting EJBObject id", (Throwable)e);
                throw new UnknownException((Throwable)e);
            }
            Invocation inv = new Invocation(id, op.getMethod(), arguments, tx, null, null);
            inv.setValue((java.lang.Object)InvocationKey.INVOKER_PROXY_BINDING, (java.lang.Object)"iiop", PayloadKey.AS_IS);
            inv.setType(InvocationType.REMOTE);
            java.lang.Object object = this.mbeanServer.invoke(this.containerName, "invoke", new java.lang.Object[]{inv}, Invocation.INVOKE_SIGNATURE);
            return object;
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

