/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.jacorb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jboss.iiop.CorbaORBService;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.DomainServerSocketFactory;
import org.jboss.system.Registry;

public class SSLServerSocketFactory
implements org.jacorb.orb.factory.SSLServerSocketFactory,
Configurable {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$iiop$jacorb$SSLServerSocketFactory == null ? (class$org$jboss$iiop$jacorb$SSLServerSocketFactory = SSLServerSocketFactory.class$("org.jboss.iiop.jacorb.SSLServerSocketFactory")) : class$org$jboss$iiop$jacorb$SSLServerSocketFactory));
    private DomainServerSocketFactory domainFactory = null;
    private boolean require_mutual_auth = false;
    private boolean request_mutual_auth = false;
    static /* synthetic */ Class class$org$jboss$iiop$jacorb$SSLServerSocketFactory;

    public SSLServerSocketFactory(ORB orb) throws IOException {
        log.info((Object)"Creating");
        SecurityDomain securityDomain = (SecurityDomain)Registry.lookup((Object)CorbaORBService.SSL_DOMAIN);
        try {
            this.domainFactory = new DomainServerSocketFactory(securityDomain);
        }
        catch (IOException e) {
            log.warn((Object)("Could not create DomainServerSocketFactory: " + e));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception creating DomainServerSockedFactory: ", (Throwable)e);
            }
            throw e;
        }
        short serverSupportedOptions = Short.parseShort(orb.getConfiguration().getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        short serverRequiredOptions = Short.parseShort(orb.getConfiguration().getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        if ((serverSupportedOptions & 0x40) != 0) {
            this.request_mutual_auth = true;
        }
        if ((serverRequiredOptions & 0x40) != 0) {
            this.require_mutual_auth = true;
            this.request_mutual_auth = false;
        }
        if (this.request_mutual_auth) {
            log.info((Object)"Will create SSL sockets that support client authentication");
        } else if (this.require_mutual_auth) {
            log.info((Object)"Will create SSL sockets that require client authentication");
        }
        log.info((Object)"Created");
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.domainFactory.createServerSocket(port);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.domainFactory.createServerSocket(port, backlog);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.domainFactory.createServerSocket(port, backlog, ifAddress);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        return s;
    }

    public boolean isSSL(ServerSocket s) {
        return s instanceof SSLServerSocket;
    }

    public void switchToClientMode(Socket socket) {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

